/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.net.URI;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.events.EventBuilder;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.RestartLoginCookie;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.util.AuthenticationFlowURLHelper;
import org.keycloak.services.util.BrowserHistoryHelper;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.utils.LockObjectsForModification;

public class SessionCodeChecks {
    private static final Logger logger = Logger.getLogger(SessionCodeChecks.class);
    private AuthenticationSessionModel authSession;
    private ClientSessionCode<AuthenticationSessionModel> clientCode;
    private Response response;
    private boolean actionRequest;
    private final RealmModel realm;
    private final UriInfo uriInfo;
    private final HttpRequest request;
    private final ClientConnection clientConnection;
    private final KeycloakSession session;
    private final EventBuilder event;
    private final String code;
    private final String execution;
    private final String clientId;
    private final String tabId;
    private final String flowPath;
    private final String authSessionId;

    public SessionCodeChecks(RealmModel realm, UriInfo uriInfo, HttpRequest request, ClientConnection clientConnection, KeycloakSession session, EventBuilder event, String authSessionId, String code, String execution, String clientId, String tabId, String flowPath) {
        this.realm = realm;
        this.uriInfo = uriInfo;
        this.request = request;
        this.clientConnection = clientConnection;
        this.session = session;
        this.event = event;
        this.code = code;
        this.execution = execution;
        this.clientId = clientId;
        this.tabId = tabId;
        this.flowPath = flowPath;
        this.authSessionId = authSessionId;
    }

    public AuthenticationSessionModel getAuthenticationSession() {
        return this.authSession;
    }

    private boolean failed() {
        return this.response != null;
    }

    public Response getResponse() {
        return this.response;
    }

    public ClientSessionCode<AuthenticationSessionModel> getClientCode() {
        return this.clientCode;
    }

    public boolean isActionRequest() {
        return this.actionRequest;
    }

    private boolean checkSsl() {
        if (this.uriInfo.getBaseUri().getScheme().equals("https")) {
            return true;
        }
        return !this.realm.getSslRequired().isRequired(this.clientConnection);
    }

    public AuthenticationSessionModel initialVerifyAuthSession() {
        AuthenticationManager.AuthResult authResult;
        if (!this.checkSsl()) {
            this.event.error("ssl_required");
            this.response = ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "httpsRequiredMessage", new Object[0]);
            return null;
        }
        if (!this.realm.isEnabled()) {
            this.event.error("realm_disabled");
            this.response = ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "realmNotEnabledMessage", new Object[0]);
            return null;
        }
        logger.debugf("Will use client '%s' in back-to-application link", (Object)this.clientId);
        ClientModel client = null;
        if (this.clientId != null) {
            client = this.realm.getClientByClientId(this.clientId);
        }
        if (client != null) {
            this.session.getContext().setClient(client);
        }
        AuthenticationSessionManager authSessionManager = new AuthenticationSessionManager(this.session);
        AuthenticationSessionModel authSession = null;
        if (this.authSessionId != null) {
            authSession = authSessionManager.getAuthenticationSessionByIdAndClient(this.realm, this.authSessionId, client, this.tabId);
        }
        AuthenticationSessionModel authSessionCookie = authSessionManager.getCurrentAuthenticationSession(this.realm, client, this.tabId);
        if (authSession != null && authSessionCookie != null && !authSession.getParentSession().getId().equals(authSessionCookie.getParentSession().getId())) {
            this.event.detail("reason", "cookie does not match auth_session query parameter");
            this.event.error("invalid_code");
            this.response = ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "invalidCodeMessage", new Object[0]);
            return null;
        }
        if (authSession != null) {
            ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSession);
            return authSession;
        }
        if (authSessionCookie != null) {
            ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSessionCookie);
            return authSessionCookie;
        }
        UserSessionModel userSession = authSessionManager.getUserSessionFromAuthCookie(this.realm);
        if (userSession == null && (authResult = (AuthenticationManager.AuthResult)LockObjectsForModification.lockUserSessionsForModification((KeycloakSession)this.session, () -> AuthenticationManager.authenticateIdentityCookie(this.session, this.realm, false))) != null) {
            userSession = authResult.getSession();
        }
        if (userSession != null) {
            LoginFormsProvider loginForm = ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSession).setSuccess("alreadyLoggedIn", new Object[0]);
            if (client == null) {
                loginForm.setAttribute("skipLink", (Object)true);
            }
            this.response = loginForm.createInfoPage();
            return null;
        }
        RootAuthenticationSessionModel existingRootAuthSession = authSessionManager.getCurrentRootAuthenticationSession(this.realm);
        this.response = this.restartAuthenticationSessionFromCookie(existingRootAuthSession);
        return null;
    }

    public boolean initialVerify() {
        this.authSession = this.initialVerifyAuthSession();
        if (this.authSession == null) {
            return false;
        }
        this.session.getContext().setAuthenticationSession(this.authSession);
        this.response = BrowserHistoryHelper.getInstance().loadSavedResponse(this.session, this.authSession);
        if (this.response != null) {
            return false;
        }
        this.event.detail("code_id", this.authSession.getParentSession().getId());
        ClientModel client = this.authSession.getClient();
        if (client == null) {
            this.event.error("client_not_found");
            this.response = ErrorPage.error(this.session, this.authSession, Response.Status.BAD_REQUEST, "unknownLoginRequesterMessage", new Object[0]);
            this.clientCode.removeExpiredClientSession();
            return false;
        }
        this.setClientToEvent(client);
        this.session.getContext().setClient(client);
        if (this.checkClientDisabled(client)) {
            this.event.error("client_disabled");
            this.response = ErrorPage.error(this.session, this.authSession, Response.Status.BAD_REQUEST, "loginRequesterNotEnabledMessage", new Object[0]);
            this.clientCode.removeExpiredClientSession();
            return false;
        }
        if (this.code == null) {
            String lastExecFromSession = this.authSession.getAuthNote("current.authentication.execution");
            String lastFlow = this.authSession.getAuthNote("current.flow.path");
            if (this.execution == null && !this.flowPath.equals(lastFlow)) {
                logger.debugf("Transition between flows! Current flow: %s, Previous flow: %s", (Object)this.flowPath, (Object)lastFlow);
                if (CommonClientSessionModel.Action.AUTHENTICATE.name().equals(this.authSession.getAction())) {
                    this.authSession.setAuthNote("current.flow.path", this.flowPath);
                    this.authSession.removeAuthNote("current.authentication.execution");
                    lastExecFromSession = null;
                }
            }
            if (this.execution == null || this.execution.equals(lastExecFromSession)) {
                this.clientCode = new ClientSessionCode<AuthenticationSessionModel>(this.session, this.realm, this.authSession);
                this.actionRequest = false;
                if (this.execution == null && lastExecFromSession != null) {
                    logger.debugf("Parameter 'execution' is not in the request, but flow wasn't changed. Will update browser history", new Object[0]);
                    this.session.setAttribute("SHOULD_UPDATE_BROWSER_HISTORY", (Object)true);
                }
                return true;
            }
            this.response = this.showPageExpired(this.authSession);
            return false;
        }
        ClientSessionCode.ParseResult<AuthenticationSessionModel> result = ClientSessionCode.parseResult(this.code, this.tabId, this.session, this.realm, client, this.event, this.authSession);
        this.clientCode = result.getCode();
        if (this.clientCode == null) {
            String latestFlowPath;
            if (ObjectUtil.isEqualOrBothNull((Object)this.execution, (Object)this.authSession.getAuthNote("current.authentication.execution")) && (latestFlowPath = this.authSession.getAuthNote("current.flow.path")) != null) {
                URI redirectUri = this.getLastExecutionUrl(latestFlowPath, this.execution, this.tabId);
                logger.debugf("Invalid action code, but execution matches. So just redirecting to %s", (Object)redirectUri);
                this.authSession.setAuthNote("forwardedErrorMessage", "expiredActionMessage");
                this.response = Response.status((Response.Status)Response.Status.FOUND).location(redirectUri).build();
                return false;
            }
            this.response = this.showPageExpired(this.authSession);
            return false;
        }
        this.actionRequest = true;
        if (this.execution != null) {
            this.authSession.setAuthNote("last.processed.execution", this.execution);
        }
        return true;
    }

    protected void setClientToEvent(ClientModel client) {
        this.event.client(client);
    }

    public boolean verifyActiveAndValidAction(String expectedAction, ClientSessionCode.ActionType actionType) {
        if (this.failed()) {
            return false;
        }
        if (!this.isActionActive(actionType)) {
            return false;
        }
        if (!this.clientCode.isValidAction(expectedAction)) {
            AuthenticationSessionModel authSession = this.getAuthenticationSession();
            if (CommonClientSessionModel.Action.REQUIRED_ACTIONS.name().equals(authSession.getAction())) {
                logger.debugf("Incorrect action '%s' . User authenticated already.", (Object)authSession.getAction());
                this.response = this.showPageExpired(authSession);
                return false;
            }
            logger.errorf("Bad action. Expected action '%s', current action '%s'", (Object)expectedAction, (Object)authSession.getAction());
            this.response = ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, "expiredCodeMessage", new Object[0]);
            return false;
        }
        return true;
    }

    protected boolean isActionActive(ClientSessionCode.ActionType actionType) {
        if (!this.clientCode.isActionActive(actionType)) {
            this.event.clone().error("expired_code");
            AuthenticationProcessor.resetFlow(this.authSession, "authenticate");
            this.authSession.setAuthNote("forwardedErrorMessage", "loginTimeout");
            URI redirectUri = this.getLastExecutionUrl("authenticate", null, this.tabId);
            logger.debugf("Flow restart after timeout. Redirecting to %s", (Object)redirectUri);
            this.response = Response.status((Response.Status)Response.Status.FOUND).location(redirectUri).build();
            return false;
        }
        return true;
    }

    public boolean verifyRequiredAction(String executedAction) {
        if (this.failed()) {
            return false;
        }
        if (!this.clientCode.isValidAction(CommonClientSessionModel.Action.REQUIRED_ACTIONS.name())) {
            logger.debugf("Expected required action, but session action is '%s' . Showing expired page now.", (Object)this.authSession.getAction());
            this.event.error("invalid_code");
            this.response = this.showPageExpired(this.authSession);
            return false;
        }
        if (!this.isActionActive(ClientSessionCode.ActionType.USER)) {
            return false;
        }
        if (this.actionRequest) {
            String currentRequiredAction = this.authSession.getAuthNote("current.authentication.execution");
            if (executedAction == null || !executedAction.equals(currentRequiredAction)) {
                logger.debug((Object)"required action doesn't match current required action");
                this.response = this.redirectToRequiredActions(currentRequiredAction);
                return false;
            }
        }
        return true;
    }

    protected Response restartAuthenticationSessionFromCookie(RootAuthenticationSessionModel existingRootSession) {
        logger.debug((Object)"Authentication session not found. Trying to restart from cookie.");
        AuthenticationSessionModel authSession = null;
        Cookie cook = RestartLoginCookie.getRestartCookie(this.session);
        if (cook == null) {
            this.event.error("cookie_not_found");
            return ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, "cookieNotFoundMessage", new Object[0]);
        }
        try {
            authSession = RestartLoginCookie.restartSession(this.session, this.realm, existingRootSession, this.clientId, cook);
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.failedToParseRestartLoginCookie(e);
        }
        if (authSession != null) {
            this.event.clone();
            this.event.detail("restart_after_timeout", "true");
            this.event.error("expired_code");
            String warningMessage = "loginTimeout";
            authSession.setAuthNote("forwardedErrorMessage", warningMessage);
            String flowPath = authSession.getClientNote("APP_INITIATED_FLOW");
            if (flowPath == null) {
                flowPath = "authenticate";
            }
            URI redirectUri = this.getLastExecutionUrl(flowPath, null, authSession.getTabId());
            logger.debugf("Authentication session restart from cookie succeeded. Redirecting to %s", (Object)redirectUri);
            return Response.status((Response.Status)Response.Status.FOUND).location(redirectUri).build();
        }
        this.event.error("invalid_code");
        return ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, "invalidCodeMessage", new Object[0]);
    }

    private Response redirectToRequiredActions(String action) {
        UriBuilder uriBuilder = LoginActionsService.loginActionsBaseUrl(this.uriInfo).path("required-action");
        if (action != null) {
            uriBuilder.queryParam("execution", new Object[]{action});
        }
        ClientModel client = this.authSession.getClient();
        uriBuilder.queryParam("client_id", new Object[]{client.getClientId()});
        uriBuilder.queryParam("tab_id", new Object[]{this.authSession.getTabId()});
        URI redirect = uriBuilder.build(new Object[]{this.realm.getName()});
        return Response.status((int)302).location(redirect).build();
    }

    private URI getLastExecutionUrl(String flowPath, String executionId, String tabId) {
        return new AuthenticationFlowURLHelper(this.session, this.realm, this.uriInfo).getLastExecutionUrl(flowPath, executionId, this.clientId, tabId);
    }

    private Response showPageExpired(AuthenticationSessionModel authSession) {
        return new AuthenticationFlowURLHelper(this.session, this.realm, this.uriInfo).showPageExpired(authSession);
    }

    protected KeycloakSession getSession() {
        return this.session;
    }

    protected EventBuilder getEvent() {
        return this.event;
    }

    protected boolean checkClientDisabled(ClientModel client) {
        return !client.isEnabled();
    }
}

