/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.installation;

import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.keycloak.Config;
import org.keycloak.authentication.ClientAuthenticator;
import org.keycloak.authentication.ClientAuthenticatorFactory;
import org.keycloak.authorization.admin.AuthorizationService;
import org.keycloak.common.Profile;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.protocol.ClientInstallationProvider;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.util.JsonSerialization;

public class KeycloakOIDCClientInstallation
implements ClientInstallationProvider {
    public Response generateInstallation(KeycloakSession session, RealmModel realm, ClientModel client, URI baseUri) {
        ClientManager.InstallationAdapterConfig rep = new ClientManager.InstallationAdapterConfig();
        rep.setAuthServerUrl(baseUri.toString());
        rep.setRealm(realm.getName());
        rep.setSslRequired(realm.getSslRequired().name().toLowerCase());
        if (client.isPublicClient() && !client.isBearerOnly()) {
            rep.setPublicClient(true);
        }
        if (client.isBearerOnly()) {
            rep.setBearerOnly(true);
        }
        if (client.getRolesStream().count() > 0L) {
            rep.setUseResourceRoleMappings(true);
        }
        rep.setResource(client.getClientId());
        if (KeycloakOIDCClientInstallation.showClientCredentialsAdapterConfig(client)) {
            Map<String, Object> adapterConfig = KeycloakOIDCClientInstallation.getClientCredentialsAdapterConfig(session, client);
            rep.setCredentials(adapterConfig);
        }
        if (KeycloakOIDCClientInstallation.showVerifyTokenAudience(client)) {
            rep.setVerifyTokenAudience(true);
        }
        this.configureAuthorizationSettings(session, client, rep);
        String json = null;
        try {
            json = JsonSerialization.writeValueAsPrettyString((Object)((Object)rep));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Response.ok((Object)json, (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
    }

    public static Map<String, Object> getClientCredentialsAdapterConfig(KeycloakSession session, ClientModel client) {
        String clientAuthenticator = client.getClientAuthenticatorType();
        ClientAuthenticatorFactory authenticator = (ClientAuthenticatorFactory)session.getKeycloakSessionFactory().getProviderFactory(ClientAuthenticator.class, clientAuthenticator);
        return authenticator.getAdapterConfiguration(client);
    }

    public static boolean showClientCredentialsAdapterConfig(ClientModel client) {
        if (client.isPublicClient()) {
            return false;
        }
        return !client.isBearerOnly() || client.isServiceAccountsEnabled() || client.getNodeReRegistrationTimeout() > 0;
    }

    static boolean showVerifyTokenAudience(ClientModel client) {
        if (client.getRolesStream().count() > 0L) {
            return true;
        }
        String clientId = client.getClientId();
        return client.getRealm().getClientScopesStream().anyMatch(clientScope -> clientScope.getProtocolMappersStream().anyMatch(protocolMapper -> Objects.equals(protocolMapper.getProtocolMapper(), "oidc-audience-mapper") && Objects.equals(clientId, protocolMapper.getConfig().get("included.client.audience"))));
    }

    public String getProtocol() {
        return "openid-connect";
    }

    public String getDisplayType() {
        return "Keycloak OIDC JSON";
    }

    public String getHelpText() {
        return "keycloak.json file used by the Keycloak OIDC client adapter to configure clients.  This must be saved to a keycloak.json file and put in your WEB-INF directory of your WAR file.  You may also want to tweak this file after you download it.";
    }

    public void close() {
    }

    public ClientInstallationProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return "keycloak-oidc-keycloak-json";
    }

    public boolean isDownloadOnly() {
        return false;
    }

    public String getFilename() {
        return "keycloak.json";
    }

    public String getMediaType() {
        return "application/json";
    }

    private void configureAuthorizationSettings(KeycloakSession session, ClientModel client, ClientManager.InstallationAdapterConfig rep) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION) && new AuthorizationService(session, client, null, null).isEnabled()) {
            PolicyEnforcerConfig enforcerConfig = new PolicyEnforcerConfig();
            enforcerConfig.setEnforcementMode(null);
            enforcerConfig.setLazyLoadPaths(null);
            rep.setEnforcerConfig(enforcerConfig);
            Iterator<RoleModel> it = client.getRolesStream().iterator();
            RoleModel role = this.hasOnlyOne(it);
            if (role != null && role.getName().equals("uma_protection")) {
                rep.setUseResourceRoleMappings(null);
            }
        }
    }

    private RoleModel hasOnlyOne(Iterator<RoleModel> it) {
        if (!it.hasNext()) {
            return null;
        }
        RoleModel role = it.next();
        if (it.hasNext()) {
            return null;
        }
        return role;
    }
}

