/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc.mappers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.keycloak.broker.oidc.mappers.AbstractClaimMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.saml.common.util.StringUtil;

public class UserAttributeMapper
extends AbstractClaimMapper {
    public static final String[] COMPATIBLE_PROVIDERS = new String[]{"keycloak-oidc", "oidc"};
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String USER_ATTRIBUTE = "user.attribute";
    public static final String EMAIL = "email";
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    private static final Set<IdentityProviderSyncMode> IDENTITY_PROVIDER_SYNC_MODES = new HashSet<IdentityProviderSyncMode>(Arrays.asList(IdentityProviderSyncMode.values()));
    public static final String PROVIDER_ID = "oidc-user-attribute-idp-mapper";

    public boolean supportsSyncMode(IdentityProviderSyncMode syncMode) {
        return IDENTITY_PROVIDER_SYNC_MODES.contains(syncMode);
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    public String getDisplayCategory() {
        return "Attribute Importer";
    }

    public String getDisplayType() {
        return "Attribute Importer";
    }

    public void preprocessFederatedIdentity(KeycloakSession session, RealmModel realm, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String attribute = (String)mapperModel.getConfig().get(USER_ATTRIBUTE);
        if (StringUtil.isNullOrEmpty((String)attribute)) {
            return;
        }
        Object value = UserAttributeMapper.getClaimValue(mapperModel, context);
        List<String> values = this.toList(value);
        if (EMAIL.equalsIgnoreCase(attribute)) {
            this.setIfNotEmpty(arg_0 -> ((BrokeredIdentityContext)context).setEmail(arg_0), values);
        } else if (FIRST_NAME.equalsIgnoreCase(attribute)) {
            this.setIfNotEmpty(arg_0 -> ((BrokeredIdentityContext)context).setFirstName(arg_0), values);
        } else if (LAST_NAME.equalsIgnoreCase(attribute)) {
            this.setIfNotEmpty(arg_0 -> ((BrokeredIdentityContext)context).setLastName(arg_0), values);
        } else {
            List valuesToString = values.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
            context.setUserAttribute(attribute, valuesToString);
        }
    }

    private void setIfNotEmpty(Consumer<String> consumer, List<String> values) {
        if (values != null && !values.isEmpty()) {
            consumer.accept(values.get(0));
        }
    }

    private List<String> toList(Object value) {
        List<Object> values = value instanceof List ? (List<Object>)value : Collections.singletonList(value);
        return values.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String attribute = (String)mapperModel.getConfig().get(USER_ATTRIBUTE);
        if (StringUtil.isNullOrEmpty((String)attribute)) {
            return;
        }
        Object value = UserAttributeMapper.getClaimValue(mapperModel, context);
        List<String> values = this.toList(value);
        if (EMAIL.equalsIgnoreCase(attribute)) {
            this.setIfNotEmpty(arg_0 -> ((UserModel)user).setEmail(arg_0), values);
        } else if (FIRST_NAME.equalsIgnoreCase(attribute)) {
            this.setIfNotEmpty(arg_0 -> ((UserModel)user).setFirstName(arg_0), values);
        } else if (LAST_NAME.equalsIgnoreCase(attribute)) {
            this.setIfNotEmpty(arg_0 -> ((UserModel)user).setLastName(arg_0), values);
        } else {
            List current = user.getAttributeStream(attribute).collect(Collectors.toList());
            if (!CollectionUtil.collectionEquals(values, current)) {
                user.setAttribute(attribute, values);
            } else if (values.isEmpty()) {
                user.removeAttribute(attribute);
            }
        }
    }

    public String getHelpText() {
        return "Import declared claim if it exists in ID, access token or the claim set returned by the user profile endpoint into the specified user property or attribute.";
    }

    static {
        ProviderConfigProperty property1 = new ProviderConfigProperty();
        property1.setName("claim");
        property1.setLabel("Claim");
        property1.setHelpText("Name of claim to search for in token. You can reference nested claims using a '.', i.e. 'address.locality'. To use dot (.) literally, escape it with backslash (\\.)");
        property1.setType("String");
        configProperties.add(property1);
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(USER_ATTRIBUTE);
        property.setLabel("User Attribute Name");
        property.setHelpText("User attribute name to store claim.  Use email, lastName, and firstName to map to those predefined user properties.");
        property.setType("String");
        configProperties.add(property);
    }
}

