/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actiontoken.updateemail;

import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.Response;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.actiontoken.AbstractActionTokenHandler;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.authentication.actiontoken.TokenUtils;
import org.keycloak.authentication.actiontoken.updateemail.UpdateEmailActionToken;
import org.keycloak.authentication.requiredactions.UpdateEmail;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.services.validation.Validation;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.ValidationException;

public class UpdateEmailActionTokenHandler
extends AbstractActionTokenHandler<UpdateEmailActionToken> {
    public UpdateEmailActionTokenHandler() {
        super("update-email", UpdateEmailActionToken.class, "staleEmailVerificationLink", EventType.EXECUTE_ACTIONS, "invalid_token");
    }

    @Override
    public TokenVerifier.Predicate<? super UpdateEmailActionToken>[] getVerifiers(ActionTokenContext<UpdateEmailActionToken> tokenContext) {
        return TokenUtils.predicates(TokenUtils.checkThat(t -> Objects.equals(t.getOldEmail(), tokenContext.getAuthenticationSession().getAuthenticatedUser().getEmail()), "invalid_email", this.getDefaultErrorMessage()));
    }

    @Override
    public Response handleToken(UpdateEmailActionToken token, ActionTokenContext<UpdateEmailActionToken> tokenContext) {
        UserProfile emailUpdateValidationResult;
        AuthenticationSessionModel authenticationSession = tokenContext.getAuthenticationSession();
        UserModel user = authenticationSession.getAuthenticatedUser();
        KeycloakSession session = tokenContext.getSession();
        LoginFormsProvider forms = ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authenticationSession).setUser(user);
        String newEmail = token.getNewEmail();
        try {
            emailUpdateValidationResult = UpdateEmail.validateEmailUpdate(session, user, newEmail);
        }
        catch (ValidationException pve) {
            List<FormMessage> errors = Validation.getFormErrorsFromValidation(pve.getErrors());
            return forms.setErrors(errors).createErrorPage(Response.Status.BAD_REQUEST);
        }
        UpdateEmail.updateEmailNow(tokenContext.getEvent(), user, emailUpdateValidationResult);
        tokenContext.getEvent().success();
        user.setEmailVerified(true);
        user.removeRequiredAction(UserModel.RequiredAction.UPDATE_EMAIL);
        tokenContext.getAuthenticationSession().removeRequiredAction(UserModel.RequiredAction.UPDATE_EMAIL);
        user.removeRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
        tokenContext.getAuthenticationSession().removeRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
        return forms.setAttribute("messageHeader", (Object)forms.getMessage("emailUpdatedTitle")).setSuccess("emailUpdated", new Object[]{newEmail}).createInfoPage();
    }

    @Override
    public boolean canUseTokenRepeatedly(UpdateEmailActionToken token, ActionTokenContext<UpdateEmailActionToken> tokenContext) {
        return false;
    }
}

