/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert;

import java.util.List;
import org.wildfly.common.Assert;
import org.wildfly.security.asn1.ASN1Encoder;
import org.wildfly.security.x500.cert.CRLDistributionPoint;
import org.wildfly.security.x500.cert.X509CertificateExtension;

public final class FreshestCRLExtension
extends X509CertificateExtension {
    private final List<CRLDistributionPoint> distributionPoints;

    public FreshestCRLExtension(List<CRLDistributionPoint> distributionPoints) {
        super(false);
        Assert.checkNotNullParam((String)"distributionPoints", distributionPoints);
        Assert.checkNotEmptyParam((String)"distributionPoints", distributionPoints);
        this.distributionPoints = distributionPoints;
    }

    @Override
    public String getId() {
        return "2.5.29.46";
    }

    @Override
    public void encodeTo(ASN1Encoder encoder) {
        encoder.startSequence();
        for (CRLDistributionPoint distributionPoint : this.distributionPoints) {
            distributionPoint.encodeTo(encoder);
        }
        encoder.endSequence();
    }
}

