/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.context.internal.shaded.WeakConcurrentMap;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.proto.common.v1.internal.InstrumentationScope;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class InstrumentationScopeMarshaller
extends MarshalerWithSize {
    private static final WeakConcurrentMap<InstrumentationScopeInfo, InstrumentationScopeMarshaller> SCOPE_MARSHALER_CACHE = new WeakConcurrentMap.WithInlinedExpunction();
    private final byte[] serializedBinary;
    private final String serializedJson;

    public static InstrumentationScopeMarshaller create(InstrumentationScopeInfo scopeInfo) {
        InstrumentationScopeMarshaller cached = (InstrumentationScopeMarshaller)((Object)SCOPE_MARSHALER_CACHE.get((Object)scopeInfo));
        if (cached == null) {
            byte[] name = MarshalerUtil.toBytes((String)scopeInfo.getName());
            byte[] version = MarshalerUtil.toBytes((String)scopeInfo.getVersion());
            RealInstrumentationScopeMarshaler realMarshaler = new RealInstrumentationScopeMarshaler(name, version);
            ByteArrayOutputStream binaryBos = new ByteArrayOutputStream(realMarshaler.getBinarySerializedSize());
            try {
                realMarshaler.writeBinaryTo(binaryBos);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Serialization error, this is likely a bug in OpenTelemetry.", e);
            }
            String json = MarshalerUtil.preserializeJsonFields((Marshaler)realMarshaler);
            cached = new InstrumentationScopeMarshaller(binaryBos.toByteArray(), json);
            SCOPE_MARSHALER_CACHE.put((Object)scopeInfo, (Object)cached);
        }
        return cached;
    }

    private InstrumentationScopeMarshaller(byte[] binary, String json) {
        super(binary.length);
        this.serializedBinary = binary;
        this.serializedJson = json;
    }

    public void writeTo(Serializer output) throws IOException {
        output.writeSerializedMessage(this.serializedBinary, this.serializedJson);
    }

    private static final class RealInstrumentationScopeMarshaler
    extends MarshalerWithSize {
        private final byte[] name;
        private final byte[] version;

        RealInstrumentationScopeMarshaler(byte[] name, byte[] version) {
            super(RealInstrumentationScopeMarshaler.computeSize(name, version));
            this.name = name;
            this.version = version;
        }

        protected void writeTo(Serializer output) throws IOException {
            output.serializeString(InstrumentationScope.NAME, this.name);
            output.serializeString(InstrumentationScope.VERSION, this.version);
        }

        private static int computeSize(byte[] name, byte[] version) {
            return MarshalerUtil.sizeBytes((ProtoFieldInfo)InstrumentationScope.NAME, (byte[])name) + MarshalerUtil.sizeBytes((ProtoFieldInfo)InstrumentationScope.VERSION, (byte[])version);
        }
    }
}

