/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.criteria;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.tree.DefaultTreeNode;
import org.keycloak.storage.SearchableModelField;

public class ModelCriteriaNode<M>
extends DefaultTreeNode<ModelCriteriaNode<M>> {
    private final ExtOperator nodeOperator;
    private final ModelCriteriaBuilder.Operator simpleOperator;
    private final SearchableModelField<? super M> field;
    private final Object[] simpleOperatorArguments;

    public ModelCriteriaNode(SearchableModelField<? super M> field, ModelCriteriaBuilder.Operator simpleOperator, Object[] simpleOperatorArguments) {
        super(Collections.emptyMap());
        this.simpleOperator = simpleOperator;
        this.field = field;
        this.simpleOperatorArguments = simpleOperatorArguments;
        this.nodeOperator = ExtOperator.ATOMIC_FORMULA;
        if (simpleOperatorArguments != null) {
            for (int i = 0; i < simpleOperatorArguments.length; ++i) {
                Object arg = simpleOperatorArguments[i];
                if (!(arg instanceof Stream)) continue;
                try (Stream sArg = (Stream)arg;){
                    simpleOperatorArguments[i] = sArg.collect(Collectors.toList());
                    continue;
                }
            }
        }
    }

    public ModelCriteriaNode(ExtOperator nodeOperator) {
        super(Collections.emptyMap());
        this.nodeOperator = nodeOperator;
        this.simpleOperator = null;
        this.field = null;
        this.simpleOperatorArguments = null;
    }

    public ExtOperator getNodeOperator() {
        return this.nodeOperator;
    }

    public ModelCriteriaBuilder.Operator getSimpleOperator() {
        return this.simpleOperator;
    }

    public SearchableModelField<? super M> getField() {
        return this.field;
    }

    public Object[] getSimpleOperatorArguments() {
        return this.simpleOperatorArguments;
    }

    public ModelCriteriaNode<M> cloneTree() {
        return this.cloneTree(ModelCriteriaNode::new, ModelCriteriaNode::new);
    }

    public ModelCriteriaNode<M> cloneTree(AtomicFormulaInstantiator<M> atomicFormulaInstantiator, Function<ExtOperator, ModelCriteriaNode<M>> booleanNodeInstantiator) {
        return this.cloneTree(n -> n.getNodeOperator() == ExtOperator.ATOMIC_FORMULA ? atomicFormulaInstantiator.instantiate(n.field, n.simpleOperator, n.simpleOperatorArguments) : (ModelCriteriaNode)booleanNodeInstantiator.apply(n.nodeOperator));
    }

    public boolean isFalseNode() {
        return this.getNodeOperator() == ExtOperator.__FALSE__;
    }

    public boolean isNotFalseNode() {
        return this.getNodeOperator() != ExtOperator.__FALSE__;
    }

    public boolean isTrueNode() {
        return this.getNodeOperator() == ExtOperator.__TRUE__;
    }

    public boolean isNotTrueNode() {
        return this.getNodeOperator() != ExtOperator.__TRUE__;
    }

    public <C extends ModelCriteriaBuilder<M, C>> C flashToModelCriteriaBuilder(C mcb) {
        C res = this.nodeOperator.apply(mcb, this);
        return res == null ? mcb : res;
    }

    @Override
    public String toString() {
        return this.nodeOperator.toString(this);
    }

    @FunctionalInterface
    public static interface AtomicFormulaInstantiator<M> {
        public ModelCriteriaNode<M> instantiate(SearchableModelField<? super M> var1, ModelCriteriaBuilder.Operator var2, Object[] var3);
    }

    public static enum ExtOperator {
        AND{

            @Override
            public <M, C extends ModelCriteriaBuilder<M, C>> C apply(C mcb, ModelCriteriaNode<M> node) {
                if (node.getChildren().isEmpty()) {
                    return null;
                }
                ModelCriteriaBuilder[] operands = (ModelCriteriaBuilder[])node.getChildren().stream().map(n -> n.flashToModelCriteriaBuilder(mcb)).filter(Objects::nonNull).toArray(n -> (ModelCriteriaBuilder[])Array.newInstance(mcb.getClass(), n));
                return (C)(operands.length == 0 ? null : mcb.and(operands));
            }

            @Override
            public String toString(ModelCriteriaNode<?> node) {
                return "(" + node.getChildren().stream().map(ModelCriteriaNode::toString).collect(Collectors.joining(" && ")) + ")";
            }
        }
        ,
        OR{

            @Override
            public <M, C extends ModelCriteriaBuilder<M, C>> C apply(C mcb, ModelCriteriaNode<M> node) {
                if (node.getChildren().isEmpty()) {
                    return null;
                }
                ModelCriteriaBuilder[] operands = (ModelCriteriaBuilder[])node.getChildren().stream().map(n -> n.flashToModelCriteriaBuilder(mcb)).filter(Objects::nonNull).toArray(n -> (ModelCriteriaBuilder[])Array.newInstance(mcb.getClass(), n));
                return (C)(operands.length == 0 ? null : mcb.or(operands));
            }

            @Override
            public String toString(ModelCriteriaNode<?> node) {
                return "(" + node.getChildren().stream().map(ModelCriteriaNode::toString).collect(Collectors.joining(" || ")) + ")";
            }
        }
        ,
        NOT{

            @Override
            public <M, C extends ModelCriteriaBuilder<M, C>> C apply(C mcb, ModelCriteriaNode<M> node) {
                ModelCriteriaNode child = (ModelCriteriaNode)node.getChildren().iterator().next();
                return (C)(child.isFalseNode() ? mcb.and((ModelCriteriaBuilder[])Array.newInstance(mcb.getClass(), 0)) : (child.isTrueNode() ? mcb.or((ModelCriteriaBuilder[])Array.newInstance(mcb.getClass(), 0)) : mcb.not(child.flashToModelCriteriaBuilder(mcb))));
            }

            @Override
            public String toString(ModelCriteriaNode<?> node) {
                return "! " + ((ModelCriteriaNode)node.getChildren().iterator().next()).toString();
            }
        }
        ,
        ATOMIC_FORMULA{

            @Override
            public <M, C extends ModelCriteriaBuilder<M, C>> C apply(C mcb, ModelCriteriaNode<M> node) {
                return mcb.compare(node.field, node.simpleOperator, node.simpleOperatorArguments);
            }

            @Override
            public String toString(ModelCriteriaNode<?> node) {
                return node.field.getName() + " " + node.simpleOperator + " " + Arrays.deepToString(node.simpleOperatorArguments);
            }
        }
        ,
        __FALSE__{

            @Override
            public <M, C extends ModelCriteriaBuilder<M, C>> C apply(C mcb, ModelCriteriaNode<M> node) {
                return (C)mcb.or((ModelCriteriaBuilder[])Array.newInstance(mcb.getClass(), 0));
            }

            @Override
            public String toString(ModelCriteriaNode<?> node) {
                return "__FALSE__";
            }
        }
        ,
        __TRUE__{

            @Override
            public <M, C extends ModelCriteriaBuilder<M, C>> C apply(C mcb, ModelCriteriaNode<M> node) {
                return (C)mcb.and((ModelCriteriaBuilder[])Array.newInstance(mcb.getClass(), 0));
            }

            @Override
            public String toString(ModelCriteriaNode<?> node) {
                return "__TRUE__";
            }
        };


        public abstract <M, C extends ModelCriteriaBuilder<M, C>> C apply(C var1, ModelCriteriaNode<M> var2);

        public abstract String toString(ModelCriteriaNode<?> var1);
    }
}

