/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.group;

import java.util.stream.Collectors;
import org.keycloak.models.GroupModel;
import org.keycloak.models.GroupProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.group.MapGroupEntity;
import org.keycloak.models.map.group.MapGroupProvider;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.provider.ProviderEvent;

public class MapGroupProviderFactory
extends AbstractMapProviderFactory<MapGroupProvider, MapGroupEntity, GroupModel>
implements GroupProviderFactory<MapGroupProvider>,
InvalidationHandler {
    public MapGroupProviderFactory() {
        super(GroupModel.class, MapGroupProvider.class);
    }

    @Override
    public MapGroupProvider createNew(KeycloakSession session) {
        return new MapGroupProvider(session, this.getStorage(session));
    }

    public String getHelpText() {
        return "Group provider";
    }

    public void invalidate(final KeycloakSession session, InvalidationHandler.InvalidableObjectType type, final Object ... params) {
        if (type == AbstractMapProviderFactory.MapProviderObjectType.REALM_BEFORE_REMOVE) {
            ((MapGroupProvider)this.create(session)).preRemove((RealmModel)params[0]);
        } else if (type == AbstractMapProviderFactory.MapProviderObjectType.ROLE_BEFORE_REMOVE) {
            ((MapGroupProvider)this.create(session)).preRemove((RealmModel)params[0], (RoleModel)params[1]);
        } else if (type == AbstractMapProviderFactory.MapProviderObjectType.GROUP_BEFORE_REMOVE) {
            RealmModel realm = (RealmModel)params[0];
            GroupModel group = (GroupModel)params[1];
            realm.removeDefaultGroup(group);
            group.getSubGroupsStream().collect(Collectors.toSet()).forEach(subGroup -> ((MapGroupProvider)this.create(session)).removeGroup(realm, (GroupModel)subGroup));
        } else if (type == AbstractMapProviderFactory.MapProviderObjectType.GROUP_AFTER_REMOVE) {
            session.getKeycloakSessionFactory().publish((ProviderEvent)new GroupModel.GroupRemovedEvent(){

                public RealmModel getRealm() {
                    return (RealmModel)params[0];
                }

                public GroupModel getGroup() {
                    return (GroupModel)params[1];
                }

                public KeycloakSession getKeycloakSession() {
                    return session;
                }
            });
        }
    }
}

