/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.jaspi.impl;

import java.io.IOException;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.CallbackUtil;
import org.wildfly.security.auth.jaspi._private.ElytronMessages;
import org.wildfly.security.auth.jaspi.impl.SecurityActions;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.permission.ElytronPermission;

public class JaspiAuthenticationContext {
    static final ElytronPermission CREATE_AUTH_CONTEXT = ElytronPermission.forName((String)"createServerAuthenticationContext");
    private final SecurityDomain securityDomain;
    private final boolean integrated;
    private CachedIdentity cachedIdentity = null;
    private volatile SecurityIdentity securityIdentity = null;
    private final Set<String> roles = new HashSet<String>();

    JaspiAuthenticationContext(SecurityDomain securityDomain, boolean integrated) {
        this.securityDomain = securityDomain;
        this.integrated = integrated;
    }

    JaspiAuthenticationContext(SecurityDomain securityDomain, boolean integrated, CachedIdentity cachedIdentity) {
        this.securityDomain = securityDomain;
        this.integrated = integrated;
        this.cachedIdentity = cachedIdentity;
    }

    public static JaspiAuthenticationContext newInstance(SecurityDomain securityDomain, boolean integrated) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)CREATE_AUTH_CONTEXT);
        }
        return new JaspiAuthenticationContext((SecurityDomain)Assert.checkNotNullParam((String)"securityDomain", (Object)securityDomain), integrated);
    }

    public static JaspiAuthenticationContext newInstance(SecurityDomain securityDomain, boolean integrated, CachedIdentity cachedIdentity) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)CREATE_AUTH_CONTEXT);
        }
        return new JaspiAuthenticationContext((SecurityDomain)Assert.checkNotNullParam((String)"securityDomain", (Object)securityDomain), integrated, cachedIdentity);
    }

    public CallbackHandler createCallbackHandler() {
        return this.createCommonCallbackHandler(this.integrated);
    }

    private CallbackHandler createCommonCallbackHandler(final boolean integrated) {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                try {
                    SecurityActions.doPrivileged(() -> {
                        this.handleOne(callbacks, 0);
                        return null;
                    });
                }
                catch (Exception e) {
                    if (e instanceof PrivilegedActionException) {
                        if (e.getCause() instanceof UnsupportedCallbackException) {
                            throw (UnsupportedCallbackException)e.getCause();
                        }
                        if (e.getCause() instanceof IOException) {
                            throw (IOException)e.getCause();
                        }
                    }
                    throw new IOException(e);
                }
            }

            /*
             * Unable to fully structure code
             */
            private void handleOne(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
                block31: {
                    block30: {
                        if (callbacks.length == index) {
                            return;
                        }
                        callback = callbacks[index];
                        if (!(callback instanceof PasswordValidationCallback)) break block30;
                        pvc = (PasswordValidationCallback)callback;
                        username = pvc.getUsername();
                        ElytronMessages.log.tracef("Handling PasswordValidationCallback for '%s'", username);
                        evidence = new PasswordGuessEvidence(pvc.getPassword());
                        try {
                            authenticated = JaspiAuthenticationContext.access$000(JaspiAuthenticationContext.this).authenticate(username, (Evidence)evidence);
                            pvc.setResult(true);
                            JaspiAuthenticationContext.access$102(JaspiAuthenticationContext.this, authenticated);
                            JaspiAuthenticationContext.access$202(JaspiAuthenticationContext.this, new CachedIdentity("JASPI", true, authenticated));
                        }
                        catch (Exception e) {
                            ElytronMessages.log.trace("Authentication failed", e);
                            pvc.setResult(false);
                        }
                        break block31;
                    }
                    if (!(callback instanceof CallerPrincipalCallback)) ** GOTO lbl76
                    ElytronMessages.log.trace("Handling CallerPrincipalCallback");
                    cpc = (CallerPrincipalCallback)callback;
                    originalPrincipal = cpc.getPrincipal();
                    callerName = cpc.getName();
                    callerPrincipal = originalPrincipal != null ? originalPrincipal : (callerName != null ? new NamePrincipal(callerName) : null);
                    ElytronMessages.log.tracef("Original Principal = '%s', Caller Name = '%s', Resulting Principal = '%s'", originalPrincipal, callerName, callerPrincipal);
                    authorizedIdentity = null;
                    securityIdentityToImport = null;
                    if (JaspiAuthenticationContext.access$200(JaspiAuthenticationContext.this) != null) {
                        securityIdentityToImport = JaspiAuthenticationContext.access$200(JaspiAuthenticationContext.this).getSecurityIdentity() == null ? JaspiAuthenticationContext.access$000(JaspiAuthenticationContext.this).createAdHocIdentity(JaspiAuthenticationContext.access$200(JaspiAuthenticationContext.this).getName()) : JaspiAuthenticationContext.access$200(JaspiAuthenticationContext.this).getSecurityIdentity();
                        if (callerPrincipal != null) {
                            authorizationRequired = integrated != false && securityIdentityToImport.getPrincipal().equals(callerPrincipal) == false;
                            authorizedIdentity = JaspiAuthenticationContext.access$200(JaspiAuthenticationContext.this).getSecurityIdentity().createRunAsIdentity(callerPrincipal, authorizationRequired);
                        } else if (integrated) {
                            sac = JaspiAuthenticationContext.access$000(JaspiAuthenticationContext.this).createNewAuthenticationContext();
                            try {
                                sac.importIdentity(securityIdentityToImport);
                                sac.authorize();
                                authorizedIdentity = sac.getAuthorizedIdentity();
                            }
                            finally {
                                if (sac != null) {
                                    sac.close();
                                }
                            }
                        } else {
                            authorizedIdentity = JaspiAuthenticationContext.access$200(JaspiAuthenticationContext.this).getSecurityIdentity();
                        }
                    } else {
                        if (callerPrincipal == null) {
                            this.handleOne(callbacks, index + 1);
                            return;
                        }
                        if (integrated) {
                            sac = JaspiAuthenticationContext.access$000(JaspiAuthenticationContext.this).createNewAuthenticationContext();
                            try {
                                sac.setAuthenticationPrincipal(callerPrincipal);
                                if (!sac.authorize()) ** GOTO lbl67
                                authorizedIdentity = sac.getAuthorizedIdentity();
                            }
                            finally {
                                if (sac != null) {
                                    sac.close();
                                }
                            }
                        } else {
                            authorizedIdentity = JaspiAuthenticationContext.access$000(JaspiAuthenticationContext.this).createAdHocIdentity(callerPrincipal);
                        }
                    }
lbl67:
                    // 6 sources

                    if (authorizedIdentity != null) {
                        JaspiAuthenticationContext.access$202(JaspiAuthenticationContext.this, new CachedIdentity("JASPI", true, authorizedIdentity));
                        subject = cpc.getSubject();
                        if (subject != null && !subject.isReadOnly()) {
                            subject.getPrincipals().add(authorizedIdentity.getPrincipal());
                        }
                    } else {
                        throw ElytronMessages.log.authorizationFailed();
lbl76:
                        // 1 sources

                        if (callback instanceof GroupPrincipalCallback) {
                            ElytronMessages.log.trace("Handling GroupPrincipalCallback");
                            ElytronMessages.log.trace("Handling GroupPrincipalCallback");
                            gpc = (GroupPrincipalCallback)callback;
                            groups = gpc.getGroups();
                            if (groups != null && groups.length > 0) {
                                JaspiAuthenticationContext.access$300(JaspiAuthenticationContext.this).addAll(Arrays.asList(groups));
                            }
                        } else {
                            CallbackUtil.unsupported((Callback)callback);
                            this.handleOne(callbacks, index + 1);
                        }
                    }
                }
                this.handleOne(callbacks, index + 1);
            }
        };
    }

    public SecurityIdentity getAuthorizedIdentity() throws IllegalStateException {
        SecurityIdentity securityIdentity = this.cachedIdentity.getSecurityIdentity();
        if (securityIdentity != null && this.roles.size() > 0) {
            if (ElytronMessages.log.isTraceEnabled()) {
                Iterator<String> rolesIterator = this.roles.iterator();
                StringBuilder sb = new StringBuilder(rolesIterator.next());
                while (rolesIterator.hasNext()) {
                    sb.append(",").append(rolesIterator.next());
                }
                ElytronMessages.log.tracef("Assigning roles '%s' to resulting SecurityIdentity", sb.toString());
            }
            Roles roles = Roles.fromSet(this.roles);
            RoleMapper roleMapper = RoleMapper.constant((Roles)roles);
            SecurityIdentity temp = securityIdentity;
            securityIdentity = SecurityActions.doPrivileged(() -> temp.withDefaultRoleMapper(roleMapper));
        } else {
            ElytronMessages.log.trace("No roles request of CallbackHandler.");
        }
        return securityIdentity;
    }

    static /* synthetic */ SecurityDomain access$000(JaspiAuthenticationContext x0) {
        return x0.securityDomain;
    }

    static /* synthetic */ SecurityIdentity access$102(JaspiAuthenticationContext x0, SecurityIdentity x1) {
        x0.securityIdentity = x1;
        return x0.securityIdentity;
    }

    static /* synthetic */ CachedIdentity access$202(JaspiAuthenticationContext x0, CachedIdentity x1) {
        x0.cachedIdentity = x1;
        return x0.cachedIdentity;
    }

    static /* synthetic */ CachedIdentity access$200(JaspiAuthenticationContext x0) {
        return x0.cachedIdentity;
    }

    static /* synthetic */ Set access$300(JaspiAuthenticationContext x0) {
        return x0.roles;
    }
}

