/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import java.io.IOException;
import java.util.BitSet;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;

public class MessageContext<E extends MessageContext<E>> {
    private final E parentContext;
    private final FieldDescriptor fieldDescriptor;
    private String fieldPath;
    private final Descriptor messageDescriptor;
    private final BitSet seenFields;
    private int maxSeenFieldNumber = 0;

    public MessageContext(E parentContext, FieldDescriptor fieldDescriptor, Descriptor messageDescriptor) {
        if (messageDescriptor == null) {
            throw new IllegalArgumentException("messageDescriptor cannot be null");
        }
        if (parentContext != null && fieldDescriptor == null) {
            throw new IllegalArgumentException("fieldDescriptor cannot be null for nested contexts");
        }
        if (parentContext == null && fieldDescriptor != null) {
            throw new IllegalArgumentException("fieldDescriptor must be null for root contexts");
        }
        this.parentContext = parentContext;
        this.fieldDescriptor = fieldDescriptor;
        this.messageDescriptor = messageDescriptor;
        this.seenFields = new BitSet(messageDescriptor.getFields().size() + messageDescriptor.getOneOfs().size());
    }

    public E getParentContext() {
        return this.parentContext;
    }

    public FieldDescriptor getField() {
        return this.fieldDescriptor;
    }

    public String getFieldPath() {
        if (this.fieldDescriptor == null) {
            return null;
        }
        if (this.fieldPath == null) {
            String pfqn = null;
            if (this.parentContext != null) {
                pfqn = ((MessageContext)this.parentContext).getFieldPath();
            }
            this.fieldPath = pfqn != null ? pfqn + '.' + this.fieldDescriptor.getName() : this.fieldDescriptor.getName();
        }
        return this.fieldPath;
    }

    public Descriptor getMessageDescriptor() {
        return this.messageDescriptor;
    }

    public FieldDescriptor getFieldByName(String fieldName) throws IOException {
        FieldDescriptor fd = this.messageDescriptor.findFieldByName(fieldName);
        if (fd == null) {
            throw new IOException("Unknown field name : " + fieldName);
        }
        return fd;
    }

    public boolean isFieldMarked(int fieldNumber) {
        return this.seenFields.get(fieldNumber);
    }

    public boolean markField(int fieldNumber) {
        if (this.seenFields.get(fieldNumber)) {
            return false;
        }
        this.seenFields.set(fieldNumber);
        if (this.maxSeenFieldNumber < fieldNumber) {
            this.maxSeenFieldNumber = fieldNumber;
        }
        return true;
    }

    public int getMaxSeenFieldNumber() {
        return this.maxSeenFieldNumber;
    }
}

