/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.util;

import org.keycloak.common.util.Time;
import org.keycloak.models.RealmModel;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

public class SessionTimeouts {
    public static final long ENTRY_EXPIRED_FLAG = -2L;
    public static final int MINIMAL_EXPIRATION_SEC = 300;

    public static long getUserSessionLifespanMs(RealmModel realm, UserSessionEntity userSessionEntity) {
        long timeToExpire;
        int timeSinceSessionStart = Time.currentTime() - userSessionEntity.getStarted();
        int sessionMaxLifespan = Math.max(realm.getSsoSessionMaxLifespan(), 300);
        if (userSessionEntity.isRememberMe()) {
            sessionMaxLifespan = Math.max(realm.getSsoSessionMaxLifespanRememberMe(), sessionMaxLifespan);
        }
        if ((timeToExpire = (long)(sessionMaxLifespan - timeSinceSessionStart)) <= 0L) {
            return -2L;
        }
        return Time.toMillis((long)timeToExpire);
    }

    public static long getUserSessionMaxIdleMs(RealmModel realm, UserSessionEntity userSessionEntity) {
        long maxIdleTime;
        int timeSinceLastRefresh = Time.currentTime() - userSessionEntity.getLastSessionRefresh();
        int sessionIdleMs = Math.max(realm.getSsoSessionIdleTimeout(), 300);
        if (userSessionEntity.isRememberMe()) {
            sessionIdleMs = Math.max(realm.getSsoSessionIdleTimeoutRememberMe(), sessionIdleMs);
        }
        if ((maxIdleTime = (long)(sessionIdleMs - timeSinceLastRefresh + 180)) <= 0L) {
            return -2L;
        }
        return Time.toMillis((long)maxIdleTime);
    }

    public static long getClientSessionLifespanMs(RealmModel realm, AuthenticatedClientSessionEntity clientSessionEntity) {
        long timeToExpire;
        int timeSinceTimestampUpdate = Time.currentTime() - clientSessionEntity.getTimestamp();
        int sessionMaxLifespan = Math.max(realm.getSsoSessionMaxLifespan(), realm.getSsoSessionMaxLifespanRememberMe());
        if (realm.getClientSessionMaxLifespan() > 0) {
            sessionMaxLifespan = realm.getClientSessionMaxLifespan();
        }
        if ((timeToExpire = (long)((sessionMaxLifespan = Math.max(sessionMaxLifespan, 300)) - timeSinceTimestampUpdate)) <= 0L) {
            return -2L;
        }
        return Time.toMillis((long)timeToExpire);
    }

    public static long getClientSessionMaxIdleMs(RealmModel realm, AuthenticatedClientSessionEntity clientSessionEntity) {
        long timeToExpire;
        int timeSinceTimestampUpdate = Time.currentTime() - clientSessionEntity.getTimestamp();
        int sessionIdleTimeout = Math.max(realm.getSsoSessionIdleTimeout(), realm.getSsoSessionIdleTimeoutRememberMe());
        if (realm.getClientSessionIdleTimeout() > 0) {
            sessionIdleTimeout = realm.getClientSessionIdleTimeout();
        }
        if ((timeToExpire = (long)((sessionIdleTimeout = Math.max(sessionIdleTimeout, 300)) - timeSinceTimestampUpdate + 180)) <= 0L) {
            return -2L;
        }
        return Time.toMillis((long)timeToExpire);
    }

    public static long getOfflineSessionLifespanMs(RealmModel realm, UserSessionEntity userSessionEntity) {
        if (!realm.isOfflineSessionMaxLifespanEnabled()) {
            return -1L;
        }
        int timeSinceSessionStart = Time.currentTime() - userSessionEntity.getStarted();
        int sessionMaxLifespan = Math.max(realm.getOfflineSessionMaxLifespan(), 300);
        long timeToExpire = sessionMaxLifespan - timeSinceSessionStart;
        if (timeToExpire <= 0L) {
            return -2L;
        }
        return Time.toMillis((long)timeToExpire);
    }

    public static long getOfflineSessionMaxIdleMs(RealmModel realm, UserSessionEntity userSessionEntity) {
        int timeSinceLastRefresh = Time.currentTime() - userSessionEntity.getLastSessionRefresh();
        int sessionIdle = Math.max(realm.getOfflineSessionIdleTimeout(), 300);
        long maxIdleTime = sessionIdle - timeSinceLastRefresh + 180;
        if (maxIdleTime <= 0L) {
            return -2L;
        }
        return Time.toMillis((long)maxIdleTime);
    }

    public static long getOfflineClientSessionLifespanMs(RealmModel realm, AuthenticatedClientSessionEntity authenticatedClientSessionEntity) {
        long timeToExpire;
        if (!realm.isOfflineSessionMaxLifespanEnabled() && realm.getClientOfflineSessionMaxLifespan() <= 0) {
            return -1L;
        }
        int timeSinceTimestamp = Time.currentTime() - authenticatedClientSessionEntity.getTimestamp();
        int sessionMaxLifespan = Math.max(realm.getOfflineSessionMaxLifespan(), 300);
        if (realm.getClientOfflineSessionMaxLifespan() > 0) {
            sessionMaxLifespan = realm.getClientOfflineSessionMaxLifespan();
        }
        if ((timeToExpire = (long)(sessionMaxLifespan - timeSinceTimestamp)) <= 0L) {
            return -2L;
        }
        return Time.toMillis((long)timeToExpire);
    }

    public static long getOfflineClientSessionMaxIdleMs(RealmModel realm, AuthenticatedClientSessionEntity authenticatedClientSessionEntity) {
        long maxIdleTime;
        int timeSinceLastRefresh = Time.currentTime() - authenticatedClientSessionEntity.getTimestamp();
        int sessionIdle = Math.max(realm.getOfflineSessionIdleTimeout(), 300);
        if (realm.getClientOfflineSessionIdleTimeout() > 0) {
            sessionIdle = realm.getClientOfflineSessionIdleTimeout();
        }
        if ((maxIdleTime = (long)(sessionIdle - timeSinceLastRefresh + 180)) <= 0L) {
            return -2L;
        }
        return Time.toMillis((long)maxIdleTime);
    }

    public static long getLoginFailuresLifespanMs(RealmModel realm, LoginFailureEntity loginFailureEntity) {
        return -1L;
    }

    public static long getLoginFailuresMaxIdleMs(RealmModel realm, LoginFailureEntity loginFailureEntity) {
        return -1L;
    }
}

