/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cluster.infinispan;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.ClusterProviderFactory;
import org.keycloak.cluster.infinispan.CrossDCAwareCacheFactory;
import org.keycloak.cluster.infinispan.InfinispanClusterProvider;
import org.keycloak.cluster.infinispan.InfinispanNotificationsManager;
import org.keycloak.cluster.infinispan.LockEntryPredicate;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Retry;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.DefaultInfinispanConnectionProviderFactory;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.connections.infinispan.TopologyInfo;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class InfinispanClusterProviderFactory
implements ClusterProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "infinispan";
    protected static final Logger logger = Logger.getLogger(InfinispanClusterProviderFactory.class);
    private volatile Cache<String, Serializable> workCache;
    private CrossDCAwareCacheFactory crossDCAwareCacheFactory;
    private int clusterStartupTime;
    private InfinispanNotificationsManager notificationsManager;
    private ExecutorService localExecutor = Executors.newCachedThreadPool(r -> {
        Thread thread = Executors.defaultThreadFactory().newThread(r);
        thread.setName(this.getClass().getName() + "-" + thread.getName());
        return thread;
    });
    private ViewChangeListener workCacheListener;

    public ClusterProvider create(KeycloakSession session) {
        this.lazyInit(session);
        String myAddress = InfinispanUtil.getTopologyInfo(session).getMyNodeName();
        return new InfinispanClusterProvider(this.clusterStartupTime, myAddress, this.crossDCAwareCacheFactory, this.notificationsManager, this.localExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.workCache == null) {
            InfinispanClusterProviderFactory infinispanClusterProviderFactory = this;
            synchronized (infinispanClusterProviderFactory) {
                if (this.workCache == null) {
                    InfinispanConnectionProvider ispnConnections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
                    this.workCache = ispnConnections.getCache("work");
                    this.workCacheListener = new ViewChangeListener();
                    this.workCache.getCacheManager().addListener((Object)this.workCacheListener);
                    Set<RemoteStore> remoteStores = InfinispanUtil.getRemoteStores(this.workCache);
                    this.crossDCAwareCacheFactory = CrossDCAwareCacheFactory.getFactory(this.workCache, remoteStores);
                    this.clusterStartupTime = this.initClusterStartupTime(session);
                    TopologyInfo topologyInfo = InfinispanUtil.getTopologyInfo(session);
                    String myAddress = topologyInfo.getMyNodeName();
                    String mySite = topologyInfo.getMySiteName();
                    this.notificationsManager = InfinispanNotificationsManager.create(session, this.workCache, myAddress, mySite, remoteStores);
                }
            }
        }
    }

    protected int initClusterStartupTime(KeycloakSession session) {
        Integer existingClusterStartTime = (Integer)this.crossDCAwareCacheFactory.getCache().get((Object)"cluster-start-time");
        if (existingClusterStartTime != null) {
            logger.debugf("Loaded cluster startup time: %s", (Object)Time.toDate((int)existingClusterStartTime).toString());
            return existingClusterStartTime;
        }
        int serverStartTime = (int)(session.getKeycloakSessionFactory().getServerStartupTimestamp() / 1000L);
        existingClusterStartTime = InfinispanClusterProviderFactory.putIfAbsentWithRetries(this.crossDCAwareCacheFactory, "cluster-start-time", serverStartTime, -1);
        if (existingClusterStartTime == null) {
            logger.debugf("Initialized cluster startup time to %s", (Object)Time.toDate((int)serverStartTime).toString());
            return serverStartTime;
        }
        logger.debugf("Loaded cluster startup time: %s", (Object)Time.toDate((int)existingClusterStartTime).toString());
        return existingClusterStartTime;
    }

    static <V extends Serializable> V putIfAbsentWithRetries(CrossDCAwareCacheFactory crossDCAwareCacheFactory, String key, V value, int taskTimeoutInSeconds) {
        AtomicReference resultRef = new AtomicReference();
        Retry.executeWithBackoff(iteration -> {
            try {
                Serializable result;
                if (taskTimeoutInSeconds > 0) {
                    long lifespanMs = InfinispanUtil.toHotrodTimeMs(crossDCAwareCacheFactory.getCache(), Time.toMillis((long)taskTimeoutInSeconds));
                    result = (Serializable)crossDCAwareCacheFactory.getCache().putIfAbsent((Object)key, (Object)value, lifespanMs, TimeUnit.MILLISECONDS);
                } else {
                    result = (Serializable)crossDCAwareCacheFactory.getCache().putIfAbsent((Object)key, (Object)value);
                }
                resultRef.set(result);
            }
            catch (HotRodClientException re) {
                logger.warnf((Throwable)re, "Failed to write key '%s' and value '%s' in iteration '%d' . Retrying", (Object)key, (Object)value, (Object)iteration);
                throw re;
            }
        }, (int)10, (int)10);
        return (V)((Serializable)resultRef.get());
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        InfinispanClusterProviderFactory infinispanClusterProviderFactory = this;
        synchronized (infinispanClusterProviderFactory) {
            if (this.workCache != null && this.workCacheListener != null) {
                this.workCache.removeListener((Object)this.workCacheListener);
                this.workCacheListener = null;
                this.localExecutor.shutdown();
            }
        }
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public boolean isSupported() {
        return !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }

    @Listener
    public class ViewChangeListener {
        @ViewChanged
        public void viewChanged(ViewChangedEvent event) {
            Set<String> removedNodesAddresses = this.convertAddresses(event.getOldMembers());
            Set<String> newAddresses = this.convertAddresses(event.getNewMembers());
            InfinispanClusterProviderFactory.this.localExecutor.execute(() -> {
                try {
                    EmbeddedCacheManager cacheManager = InfinispanClusterProviderFactory.this.workCache.getCacheManager();
                    Transport transport = cacheManager.getTransport();
                    if (transport == null || !transport.isCoordinator()) return;
                    removedNodesAddresses.removeAll(newAddresses);
                    if (removedNodesAddresses.isEmpty()) {
                        return;
                    }
                    logger.debugf("Nodes %s removed from cluster. Removing tasks locked by this nodes", (Object)removedNodesAddresses.toString());
                    Class<DefaultInfinispanConnectionProviderFactory> clazz = DefaultInfinispanConnectionProviderFactory.class;
                    synchronized (DefaultInfinispanConnectionProviderFactory.class) {
                        InfinispanClusterProviderFactory.this.workCache.entrySet().removeIf((Predicate)new LockEntryPredicate(removedNodesAddresses));
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        return;
                    }
                }
                catch (Throwable t) {
                    logger.error((Object)"caught exception in ViewChangeListener", t);
                }
            });
        }

        private Set<String> convertAddresses(Collection<Address> addresses) {
            return addresses.stream().map(new Function<Address, String>(){

                @Override
                public String apply(Address address) {
                    return address.toString();
                }
            }).collect(Collectors.toSet());
        }
    }
}

