/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.jpa.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.keycloak.storage.jpa.entity.FederatedUserConsentEntity;

@NamedQueries(value={@NamedQuery(name="deleteFederatedUserConsentClientScopesByRealm", query="delete from FederatedUserConsentClientScopeEntity grantedScope where grantedScope.userConsent IN (select consent from FederatedUserConsentEntity consent where consent.realmId = :realmId)"), @NamedQuery(name="deleteFederatedUserConsentClientScopesByUser", query="delete from FederatedUserConsentClientScopeEntity grantedScope where grantedScope.userConsent IN (select consent from FederatedUserConsentEntity consent where consent.userId = :userId and consent.realmId = :realmId)"), @NamedQuery(name="deleteFederatedUserConsentClientScopesByStorageProvider", query="delete from FederatedUserConsentClientScopeEntity grantedScope where grantedScope.userConsent IN (select consent from FederatedUserConsentEntity consent where consent.storageProviderId = :storageProviderId)"), @NamedQuery(name="deleteFederatedUserConsentClientScopesByClientScope", query="delete from FederatedUserConsentClientScopeEntity grantedScope where grantedScope.scopeId = :scopeId"), @NamedQuery(name="deleteFederatedUserConsentClientScopesByClient", query="delete from FederatedUserConsentClientScopeEntity grantedScope where grantedScope.userConsent IN (select consent from FederatedUserConsentEntity consent where consent.clientId = :clientId)"), @NamedQuery(name="deleteFederatedUserConsentClientScopesByExternalClient", query="delete from FederatedUserConsentClientScopeEntity grantedScope where grantedScope.userConsent IN (select consent from FederatedUserConsentEntity consent where consent.clientStorageProvider = :clientStorageProvider and consent.externalClientId = :externalClientId)"), @NamedQuery(name="deleteFederatedUserConsentClientScopesByClientStorageProvider", query="delete from FederatedUserConsentClientScopeEntity grantedScope where grantedScope.userConsent IN (select consent from FederatedUserConsentEntity consent where consent.clientStorageProvider = :clientStorageProvider)")})
@Entity
@Table(name="FED_USER_CONSENT_CL_SCOPE")
@IdClass(value=Key.class)
public class FederatedUserConsentClientScopeEntity {
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="USER_CONSENT_ID")
    protected FederatedUserConsentEntity userConsent;
    @Id
    @Column(name="SCOPE_ID")
    protected String scopeId;

    public FederatedUserConsentEntity getUserConsent() {
        return this.userConsent;
    }

    public void setUserConsent(FederatedUserConsentEntity userConsent) {
        this.userConsent = userConsent;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public void setScopeId(String scopeId) {
        this.scopeId = scopeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof FederatedUserConsentClientScopeEntity)) {
            return false;
        }
        FederatedUserConsentClientScopeEntity that = (FederatedUserConsentClientScopeEntity)o;
        Key myKey = new Key(this.userConsent, this.scopeId);
        Key hisKey = new Key(that.userConsent, that.scopeId);
        return myKey.equals(hisKey);
    }

    public int hashCode() {
        Key myKey = new Key(this.userConsent, this.scopeId);
        return myKey.hashCode();
    }

    public static class Key
    implements Serializable {
        protected FederatedUserConsentEntity userConsent;
        protected String scopeId;

        public Key() {
        }

        public Key(FederatedUserConsentEntity userConsent, String scopeId) {
            this.userConsent = userConsent;
            this.scopeId = scopeId;
        }

        public FederatedUserConsentEntity getUserConsent() {
            return this.userConsent;
        }

        public String getScopeId() {
            return this.scopeId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.userConsent != null ? !this.userConsent.getId().equals(key.userConsent != null ? key.userConsent.getId() : null) : key.userConsent != null) {
                return false;
            }
            return !(this.scopeId != null ? !this.scopeId.equals(key.scopeId) : key.scopeId != null);
        }

        public int hashCode() {
            int result = this.userConsent != null ? this.userConsent.getId().hashCode() : 0;
            result = 31 * result + (this.scopeId != null ? this.scopeId.hashCode() : 0);
            return result;
        }
    }
}

