/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.handler.ipfilter.IpFilterRule;
import io.netty.handler.ipfilter.IpFilterRuleType;
import io.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;

public class IpSubnetFilterRule
implements IpFilterRule {
    private final io.netty.handler.ipfilter.IpSubnetFilterRule rule;
    private final String cidr;

    public IpSubnetFilterRule(String cidr, IpFilterRuleType type) {
        ObjectUtil.checkNotNull((Object)cidr, (String)"cidr");
        ObjectUtil.checkNotNull((Object)type, (String)"type");
        int sep = cidr.indexOf(47);
        if (sep < 0) {
            throw new IllegalArgumentException(cidr);
        }
        this.cidr = cidr;
        this.rule = new io.netty.handler.ipfilter.IpSubnetFilterRule(cidr.substring(0, sep), Integer.parseInt(cidr.substring(sep + 1)), type);
    }

    public String cidr() {
        return this.cidr;
    }

    public boolean matches(InetSocketAddress inetSocketAddress) {
        return this.rule.matches(inetSocketAddress);
    }

    public IpFilterRuleType ruleType() {
        return this.rule.ruleType();
    }

    public String toString() {
        return "IpSubnetFilterRule{rule=" + this.rule.ruleType() + ", cidr='" + this.cidr + "'}";
    }
}

