/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.configuration;

import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.util.ProcessorInfo;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.configuration.IpFilterConfiguration;
import org.infinispan.server.core.configuration.SslConfiguration;

public abstract class ProtocolServerConfiguration<T extends ProtocolServerConfiguration>
extends ConfigurationElement<T> {
    public static final AttributeDefinition<String> DEFAULT_CACHE_NAME = AttributeDefinition.builder((String)"cache", null, String.class).immutable().build();
    public static final AttributeDefinition<String> NAME = AttributeDefinition.builder((String)"name", (Object)"").immutable().build();
    public static final AttributeDefinition<String> HOST = AttributeDefinition.builder((String)"host", (Object)"127.0.0.1").immutable().autoPersist(false).build();
    public static final AttributeDefinition<Integer> PORT = AttributeDefinition.builder((String)"port", (Object)-1).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Integer> IDLE_TIMEOUT = AttributeDefinition.builder((String)"idle-timeout", (Object)-1).immutable().build();
    public static final AttributeDefinition<Set<String>> IGNORED_CACHES = AttributeDefinition.builder((String)"ignored-caches", Collections.emptySet(), Set.class).immutable().build();
    public static final AttributeDefinition<Integer> RECV_BUF_SIZE = AttributeDefinition.builder((String)"receive-buffer-size", (Object)0).immutable().build();
    public static final AttributeDefinition<Integer> SEND_BUF_SIZE = AttributeDefinition.builder((String)"send-buffer-size", (Object)0).immutable().build();
    public static final AttributeDefinition<Boolean> START_TRANSPORT = AttributeDefinition.builder((String)"start-transport", (Object)true).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Boolean> TCP_NODELAY = AttributeDefinition.builder((String)"tcp-nodelay", (Object)true).immutable().build();
    public static final AttributeDefinition<Boolean> TCP_KEEPALIVE = AttributeDefinition.builder((String)"tcp-keepalive", (Object)false).immutable().build();
    public static final AttributeDefinition<Integer> IO_THREADS = AttributeDefinition.builder((String)"io-threads", (Object)(2 * ProcessorInfo.availableProcessors())).immutable().build();
    public static final AttributeDefinition<AdminOperationsHandler> ADMIN_OPERATION_HANDLER = AttributeDefinition.builder((String)"admin-operation-handler", null, AdminOperationsHandler.class).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Boolean> ZERO_CAPACITY_NODE = AttributeDefinition.builder((String)"zero-capacity-node", (Object)false).immutable().build();
    public static final AttributeDefinition<String> SOCKET_BINDING = AttributeDefinition.builder((String)"socket-binding", null, String.class).immutable().build();
    public static final AttributeDefinition<Boolean> IMPLICIT_CONNECTOR = AttributeDefinition.builder((String)"implicit-connector", (Object)false).immutable().autoPersist(false).build();
    private volatile boolean enabled = true;
    private final Attribute<String> defaultCacheName;
    private final Attribute<String> name;
    private final Attribute<String> host;
    private final Attribute<Integer> port;
    private final Attribute<Integer> idleTimeout;
    private final Attribute<Integer> recvBufSize;
    private final Attribute<Integer> sendBufSize;
    private final Attribute<Boolean> tcpNoDelay;
    private final Attribute<Boolean> tcpKeepAlive;
    private final Attribute<Integer> ioThreads;
    private final Attribute<Boolean> startTransport;
    private final Attribute<AdminOperationsHandler> adminOperationsHandler;
    private final Attribute<Boolean> zeroCapacityNode;
    private final Attribute<String> socketBinding;
    protected final SslConfiguration ssl;
    protected final IpFilterConfiguration ipFilter;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(ProtocolServerConfiguration.class, new AttributeDefinition[]{DEFAULT_CACHE_NAME, NAME, HOST, PORT, IDLE_TIMEOUT, IGNORED_CACHES, RECV_BUF_SIZE, SEND_BUF_SIZE, START_TRANSPORT, TCP_NODELAY, TCP_KEEPALIVE, IO_THREADS, ADMIN_OPERATION_HANDLER, ZERO_CAPACITY_NODE, SOCKET_BINDING, IMPLICIT_CONNECTOR});
    }

    protected ProtocolServerConfiguration(Enum<?> element, AttributeSet attributes, SslConfiguration ssl, IpFilterConfiguration ipFilter) {
        this(element.toString(), attributes, ssl, ipFilter);
    }

    protected ProtocolServerConfiguration(String element, AttributeSet attributes, SslConfiguration ssl, IpFilterConfiguration ipFilter) {
        super(element, attributes, new ConfigurationElement[]{ssl});
        this.ssl = ssl;
        this.ipFilter = ipFilter;
        this.defaultCacheName = attributes.attribute(DEFAULT_CACHE_NAME);
        this.zeroCapacityNode = attributes.attribute(ZERO_CAPACITY_NODE);
        this.name = attributes.attribute(NAME);
        this.host = attributes.attribute(HOST);
        this.port = attributes.attribute(PORT);
        this.idleTimeout = attributes.attribute(IDLE_TIMEOUT);
        this.recvBufSize = attributes.attribute(RECV_BUF_SIZE);
        this.sendBufSize = attributes.attribute(SEND_BUF_SIZE);
        this.startTransport = attributes.attribute(START_TRANSPORT);
        this.tcpNoDelay = attributes.attribute(TCP_NODELAY);
        this.tcpKeepAlive = attributes.attribute(TCP_KEEPALIVE);
        this.ioThreads = attributes.attribute(IO_THREADS);
        this.adminOperationsHandler = attributes.attribute(ADMIN_OPERATION_HANDLER);
        this.socketBinding = attributes.attribute(SOCKET_BINDING);
    }

    public String defaultCacheName() {
        return (String)this.defaultCacheName.get();
    }

    public String name() {
        return (String)this.name.get();
    }

    public String host() {
        return (String)this.host.get();
    }

    public int port() {
        return (Integer)this.port.get();
    }

    public int idleTimeout() {
        return (Integer)this.idleTimeout.get();
    }

    public int recvBufSize() {
        return (Integer)this.recvBufSize.get();
    }

    public int sendBufSize() {
        return (Integer)this.sendBufSize.get();
    }

    public SslConfiguration ssl() {
        return this.ssl;
    }

    public IpFilterConfiguration ipFilter() {
        return this.ipFilter;
    }

    public boolean tcpNoDelay() {
        return (Boolean)this.tcpNoDelay.get();
    }

    public boolean tcpKeepAlive() {
        return (Boolean)this.tcpKeepAlive.get();
    }

    public int ioThreads() {
        return (Integer)this.ioThreads.get();
    }

    public boolean startTransport() {
        return (Boolean)this.startTransport.get();
    }

    public AdminOperationsHandler adminOperationsHandler() {
        return (AdminOperationsHandler)this.adminOperationsHandler.get();
    }

    public String socketBinding() {
        return (String)this.socketBinding.get();
    }

    public boolean zeroCapacityNode() {
        return (Boolean)this.zeroCapacityNode.get();
    }

    public void disable() {
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isImplicit() {
        return (Boolean)this.attributes.attribute(IMPLICIT_CONNECTOR).get();
    }
}

