/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.backup.resources;

import io.reactivex.rxjava3.core.Flowable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.reactive.RxJavaInterop;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.server.core.BackupManager;
import org.infinispan.server.core.backup.resources.AbstractContainerResource;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletionStages;
import org.reactivestreams.Publisher;

public class CounterResource
extends AbstractContainerResource {
    private static final String COUNTERS_FILE = "counters.dat";
    private final CounterManager counterManager;
    private final ImmutableSerializationContext serCtx;

    CounterResource(CounterManager counterManager, BlockingManager blockingManager, ImmutableSerializationContext serCtx, BackupManager.Resources params, Path root) {
        super(BackupManager.Resources.Type.COUNTERS, params, blockingManager, root);
        this.counterManager = counterManager;
        this.serCtx = serCtx;
    }

    @Override
    public void prepareAndValidateBackup() {
        if (this.wildcard) {
            this.resources.addAll(this.counterManager.getCounterNames());
            return;
        }
        for (String counterName : this.resources) {
            if (this.counterManager.getConfiguration(counterName) != null) continue;
            throw log.unableToFindResource(this.type.toString(), counterName);
        }
    }

    @Override
    public CompletionStage<Void> backup() {
        return this.blockingManager.blockingPublisherToVoidStage((Publisher)Flowable.using(() -> {
            this.mkdirs(this.root);
            return new DataOutputStream(Files.newOutputStream(this.root.resolve(COUNTERS_FILE), new OpenOption[0]));
        }, output -> Flowable.fromIterable((Iterable)this.resources).map(counter -> {
            CounterConfiguration config = this.counterManager.getConfiguration(counter);
            CounterBackupEntry e = new CounterBackupEntry();
            e.name = counter;
            e.configuration = config;
            e.value = config.type() == CounterType.WEAK ? this.counterManager.getWeakCounter(counter).getValue() : ((Long)CompletionStages.join((CompletionStage)this.counterManager.getStrongCounter(counter).getValue())).longValue();
            return e;
        }).doOnNext(e -> {
            CounterResource.writeMessageStream(e, this.serCtx, output);
            log.debugf("Counter added to backup: %s", e);
        }).onErrorResumeNext(RxJavaInterop.cacheExceptionWrapper()), OutputStream::close), (Object)"write-counters");
    }

    @Override
    public CompletionStage<Void> restore(ZipFile zip) {
        return this.blockingManager.runBlocking(() -> {
            Set countersToRestore = this.resources;
            String countersFile = this.root.resolve(COUNTERS_FILE).toString();
            ZipEntry zipEntry = zip.getEntry(countersFile);
            if (zipEntry == null) {
                if (!countersToRestore.isEmpty()) {
                    throw log.unableToFindBackupResource(this.type.toString(), countersToRestore);
                }
                return;
            }
            try (DataInputStream is = new DataInputStream(zip.getInputStream(zipEntry));){
                while (is.available() > 0) {
                    WeakCounter counter;
                    CounterBackupEntry entry = CounterResource.readMessageStream(this.serCtx, CounterBackupEntry.class, is);
                    if (!countersToRestore.contains(entry.name)) {
                        log.debugf("Ignoring '%s' counter", entry.name);
                        continue;
                    }
                    CounterConfiguration config = entry.configuration;
                    this.counterManager.defineCounter(entry.name, config);
                    if (config.type() == CounterType.WEAK) {
                        counter = this.counterManager.getWeakCounter(entry.name);
                        counter.add(entry.value - config.initialValue());
                    } else {
                        counter = this.counterManager.getStrongCounter(entry.name);
                        counter.compareAndSet(config.initialValue(), entry.value);
                    }
                    log.debugf("Counter restored: %s", entry);
                }
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        }, (Object)"restore-counters");
    }

    @ProtoTypeId(value=5402)
    public static class CounterBackupEntry {
        @ProtoField(number=1)
        String name;
        @ProtoField(number=2)
        CounterConfiguration configuration;
        @ProtoField(number=3, defaultValue="-1")
        long value;

        public String toString() {
            return "CounterBackupEntry{name='" + this.name + "', configuration=" + this.configuration + ", value=" + this.value + "}";
        }
    }
}

