/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.DiscoverySelectorIdentifier;
import org.junit.platform.engine.discovery.DiscoverySelectorIdentifierParser;
import org.junit.platform.engine.discovery.DiscoverySelectors;

@API(status=API.Status.STABLE, since="1.1")
public final class ModuleSelector
implements DiscoverySelector {
    private final @Nullable Module module;
    private final String moduleName;

    ModuleSelector(Module module) {
        this.module = module;
        this.moduleName = module.getName();
    }

    ModuleSelector(String moduleName) {
        this.module = null;
        this.moduleName = moduleName;
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.1")
    public Optional<Module> getModule() {
        return Optional.ofNullable(this.module);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    @API(status=API.Status.STABLE, since="1.3")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleSelector that = (ModuleSelector)o;
        return Objects.equals(this.moduleName, that.moduleName);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public int hashCode() {
        return this.moduleName.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("moduleName", (Object)this.moduleName).toString();
    }

    @Override
    public Optional<DiscoverySelectorIdentifier> toIdentifier() {
        return Optional.of(DiscoverySelectorIdentifier.create("module", this.moduleName));
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static class IdentifierParser
    implements DiscoverySelectorIdentifierParser {
        private static final String PREFIX = "module";

        @Override
        public String getPrefix() {
            return PREFIX;
        }

        public Optional<ModuleSelector> parse(DiscoverySelectorIdentifier identifier, DiscoverySelectorIdentifierParser.Context context) {
            return Optional.of(DiscoverySelectors.selectModule(identifier.getValue()));
        }
    }
}

