/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.discovery;

import java.util.function.Predicate;
import org.junit.platform.commons.io.Resource;

class ResourceUtils {
    public static final String DEFAULT_PACKAGE_NAME = "";
    private static final char CLASSPATH_RESOURCE_PATH_SEPARATOR = '/';
    private static final char PACKAGE_SEPARATOR_CHAR = '.';

    static Predicate<Resource> packageName(Predicate<String> packageFilter) {
        return resource -> packageFilter.test(ResourceUtils.packageName(resource.getName()));
    }

    private static String packageName(String classpathResourceName) {
        int lastIndexOf = classpathResourceName.lastIndexOf(47);
        if (lastIndexOf < 0) {
            return DEFAULT_PACKAGE_NAME;
        }
        String resourcePackagePath = classpathResourceName.substring(0, lastIndexOf);
        return resourcePackagePath.replace('/', '.');
    }

    private ResourceUtils() {
    }
}

