/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.junit.jupiter.api.function.Executable;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.opentest4j.TestAbortedException;

@API(value=API.Usage.Maintained)
public final class Assumptions {
    private Assumptions() {
    }

    public static void assumeTrue(boolean assumption) throws TestAbortedException {
        Assumptions.assumeTrue(() -> assumption);
    }

    public static void assumeTrue(BooleanSupplier assumptionSupplier) throws TestAbortedException {
        Assumptions.assumeTrue(assumptionSupplier, () -> "assumption is not true");
    }

    public static void assumeTrue(BooleanSupplier assumptionSupplier, String message) throws TestAbortedException {
        Assumptions.assumeTrue(assumptionSupplier, () -> message);
    }

    public static void assumeTrue(boolean assumption, Supplier<String> messageSupplier) throws TestAbortedException {
        Assumptions.assumeTrue(() -> assumption, messageSupplier);
    }

    public static void assumeTrue(boolean assumption, String message) throws TestAbortedException {
        Assumptions.assumeTrue(() -> assumption, () -> message);
    }

    public static void assumeTrue(BooleanSupplier assumptionSupplier, Supplier<String> messageSupplier) throws TestAbortedException {
        if (!assumptionSupplier.getAsBoolean()) {
            Assumptions.throwTestAbortedException(messageSupplier.get());
        }
    }

    public static void assumeFalse(boolean assumption) throws TestAbortedException {
        Assumptions.assumeFalse(() -> assumption);
    }

    public static void assumeFalse(BooleanSupplier assumptionSupplier) throws TestAbortedException {
        Assumptions.assumeFalse(assumptionSupplier, () -> "assumption is not false");
    }

    public static void assumeFalse(BooleanSupplier assumptionSupplier, String message) throws TestAbortedException {
        Assumptions.assumeFalse(assumptionSupplier, () -> message);
    }

    public static void assumeFalse(boolean assumption, Supplier<String> messageSupplier) throws TestAbortedException {
        Assumptions.assumeFalse(() -> assumption, messageSupplier);
    }

    public static void assumeFalse(boolean assumption, String message) throws TestAbortedException {
        Assumptions.assumeFalse(() -> assumption, () -> message);
    }

    public static void assumeFalse(BooleanSupplier assumptionSupplier, Supplier<String> messageSupplier) throws TestAbortedException {
        if (assumptionSupplier.getAsBoolean()) {
            Assumptions.throwTestAbortedException(messageSupplier.get());
        }
    }

    @API(value=API.Usage.Experimental)
    public static void assumingThat(BooleanSupplier assumptionSupplier, Executable executable) {
        Assumptions.assumingThat(assumptionSupplier.getAsBoolean(), executable);
    }

    @API(value=API.Usage.Experimental)
    public static void assumingThat(boolean assumption, Executable executable) {
        if (assumption) {
            try {
                executable.execute();
            }
            catch (Throwable t) {
                ExceptionUtils.throwAsUncheckedException((Throwable)t);
            }
        }
    }

    private static void throwTestAbortedException(String message) {
        throw new TestAbortedException(StringUtils.isNotBlank((String)message) ? "Assumption failed: " + message : "Assumption failed");
    }
}

