/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.parallel;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jsmart.zerocode.core.utils.PropertiesProviderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorServiceRunner.class);
    private final List<Runnable> runnables = new ArrayList<Runnable>();
    private final List<Callable<Object>> callables = new ArrayList<Callable<Object>>();
    private int numberOfThreads;
    private int rampUpPeriod;
    private int loopCount;
    private Double delayBetweenTwoThreadsInMilliSecs;

    public ExecutorServiceRunner(String loadPropertiesFile) {
        Properties properties = PropertiesProviderUtils.getProperties(loadPropertiesFile);
        this.numberOfThreads = Integer.parseInt(properties.getProperty("number.of.threads"));
        this.rampUpPeriod = Integer.parseInt(properties.getProperty("ramp.up.period.in.seconds"));
        this.loopCount = Integer.parseInt(properties.getProperty("loop.count"));
        this.calculateAndSetDelayBetweenTwoThreadsInSecs(this.rampUpPeriod);
        this.logLoadingProperties();
    }

    public ExecutorServiceRunner(int numberOfThreads, int loopCount, int rampUpPeriod) {
        this.numberOfThreads = numberOfThreads;
        this.loopCount = loopCount;
        this.rampUpPeriod = rampUpPeriod;
        this.calculateAndSetDelayBetweenTwoThreadsInSecs(this.rampUpPeriod);
        this.logLoadingProperties();
    }

    public ExecutorServiceRunner addRunnable(Runnable runnable) {
        this.runnables.add(runnable);
        return this;
    }

    public ExecutorServiceRunner addCallable(Callable callable) {
        this.callables.add(callable);
        return this;
    }

    public void runRunnables() {
        if (this.runnables == null || this.runnables.size() == 0) {
            throw new RuntimeException("No runnable(s) was found to run. You can add one or more runnables using 'addRunnable(Runnable runnable)'");
        }
        ExecutorService executorService = Executors.newFixedThreadPool(this.numberOfThreads);
        try {
            for (int i = 0; i < this.loopCount; ++i) {
                this.runnables.stream().forEach(thisFunction -> {
                    for (int j = 0; j < this.numberOfThreads; ++j) {
                        try {
                            LOGGER.info("Waiting for the next test flight to adjust the overall ramp up time, waiting time in the transit now = " + this.delayBetweenTwoThreadsInMilliSecs);
                            Thread.sleep(this.delayBetweenTwoThreadsInMilliSecs.longValue());
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        LOGGER.info(Thread.currentThread().getName() + " Executor - *Start... Time = " + LocalDateTime.now());
                        executorService.execute((Runnable)thisFunction);
                        LOGGER.info(Thread.currentThread().getName() + " Executor - *Finished Time = " + LocalDateTime.now());
                    }
                });
            }
        }
        catch (Exception interruptEx) {
            throw new RuntimeException(interruptEx);
        }
        finally {
            executorService.shutdown();
            while (!executorService.isTerminated()) {
            }
            LOGGER.info("**Finished executing all threads**");
        }
    }

    public void runRunnablesMulti() {
        if (this.runnables == null || this.runnables.size() == 0) {
            throw new RuntimeException("No runnable(s) was found to run. You can add one or more runnables using 'addRunnable(Runnable runnable)'");
        }
        ExecutorService executorService = Executors.newFixedThreadPool(this.numberOfThreads);
        try {
            AtomicInteger functionIndex = new AtomicInteger();
            for (int i = 0; i < this.loopCount; ++i) {
                for (int j = 0; j < this.numberOfThreads; ++j) {
                    try {
                        LOGGER.info("Waiting for the next test flight to adjust the overall ramp up time, waiting time in the transit now = " + this.delayBetweenTwoThreadsInMilliSecs);
                        Thread.sleep(this.delayBetweenTwoThreadsInMilliSecs.longValue());
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    LOGGER.info(Thread.currentThread().getName() + " Executor - *Start... Time = " + LocalDateTime.now());
                    executorService.execute(this.runnables.get(functionIndex.getAndIncrement()));
                    LOGGER.info(Thread.currentThread().getName() + " Executor - *Finished Time = " + LocalDateTime.now());
                    if (functionIndex.get() != this.runnables.size()) continue;
                    functionIndex.set(0);
                }
            }
        }
        catch (Exception interruptEx) {
            throw new RuntimeException(interruptEx);
        }
        finally {
            executorService.shutdown();
            while (!executorService.isTerminated()) {
            }
            LOGGER.info("**Finished executing all threads**");
        }
    }

    public void runCallables() {
        this.runCallableFutures();
    }

    public void runCallableFutures() {
        if (this.callables == null || this.callables.size() == 0) {
            throw new RuntimeException("No callable(s) was found to run. You can add one or more callables using 'addCallable(Callable callable)'");
        }
        ExecutorService executorService = Executors.newFixedThreadPool(this.numberOfThreads);
        try {
            executorService.invokeAll(this.callables).stream().forEach(future -> {
                for (int j = 0; j < this.numberOfThreads; ++j) {
                    try {
                        LOGGER.info("Waiting in the transit for next test flight to adjust overall ramp up time, wait time now = " + this.delayBetweenTwoThreadsInMilliSecs);
                        Thread.sleep(this.delayBetweenTwoThreadsInMilliSecs.longValue());
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    LOGGER.info(Thread.currentThread().getName() + " Future execution- Start.... Time = " + LocalDateTime.now());
                    this.execute((Future<Object>)future);
                    LOGGER.info(Thread.currentThread().getName() + " Future execution- *Finished Time = " + LocalDateTime.now());
                }
            });
        }
        catch (InterruptedException interruptEx) {
            throw new RuntimeException(interruptEx);
        }
        finally {
            executorService.shutdown();
            while (!executorService.isTerminated()) {
            }
            LOGGER.info("Finished all threads");
        }
    }

    public <T> Callable<Object> createCallableFuture(T objectToConsumer, Consumer<T> consumer) {
        return () -> {
            consumer.accept(objectToConsumer);
            return true;
        };
    }

    private Object execute(Future<Object> future) {
        try {
            LOGGER.info("executing the 'Future' now...");
            return future.get();
        }
        catch (Exception futureEx) {
            if (futureEx.getCause() instanceof InternalServerErrorException) {
                throw (InternalServerErrorException)futureEx.getCause();
            }
            throw new RuntimeException(futureEx);
        }
    }

    private void calculateAndSetDelayBetweenTwoThreadsInSecs(int rampUpPeriod) {
        this.delayBetweenTwoThreadsInMilliSecs = rampUpPeriod == 0 ? Double.valueOf(0.0) : Double.valueOf(Double.valueOf(rampUpPeriod) / Double.valueOf(this.numberOfThreads) * 1000.0);
    }

    public List<Runnable> getRunnables() {
        return this.runnables;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public int getRampUpPeriod() {
        return this.rampUpPeriod;
    }

    public List<Callable<Object>> getCallables() {
        return this.callables;
    }

    private void logLoadingProperties() {
        LOGGER.info("\nLOAD:\n-----------------------------------\n   ### numberOfThreads : " + this.numberOfThreads + "\n   ### rampUpPeriodInSeconds : " + this.rampUpPeriod + "\n   ### loopCount : " + this.loopCount + "\n-----------------------------------\n");
    }
}

