/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.utils;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.jsmart.zerocode.core.engine.preprocessor.ZeroCodeTokens;
import org.jsmart.zerocode.core.utils.SmartUtils;

public class TokenUtils {
    public static String resolveKnownTokens(String requestJsonOrAnyString) {
        HashMap paramMap = new HashMap();
        List<String> testCaseTokens = TokenUtils.getTestCaseTokens(requestJsonOrAnyString);
        testCaseTokens.forEach(runTimeToken -> TokenUtils.populateParamMap(paramMap, runTimeToken));
        StrSubstitutor sub = new StrSubstitutor(paramMap);
        return sub.replace(requestJsonOrAnyString);
    }

    public static void populateParamMap(Map<String, Object> paramaMap, String runTimeToken) {
        ZeroCodeTokens.getKnownTokens().forEach(inStoreToken -> {
            if (runTimeToken.startsWith((String)inStoreToken)) {
                if (runTimeToken.startsWith("RANDOM.NUMBER")) {
                    paramaMap.put(runTimeToken, System.currentTimeMillis() + "");
                } else if (runTimeToken.startsWith("RANDOM.STRING:")) {
                    int length = Integer.parseInt(runTimeToken.substring("RANDOM.STRING:".length()));
                    paramaMap.put(runTimeToken, TokenUtils.createRandomAlphaString(length));
                } else if (runTimeToken.startsWith("STATIC.ALPHABET:")) {
                    int length = Integer.parseInt(runTimeToken.substring("STATIC.ALPHABET:".length()));
                    paramaMap.put(runTimeToken, TokenUtils.createStaticAlphaString(length));
                } else if (runTimeToken.startsWith("LOCAL.DATE.TODAY:")) {
                    String formatPattern = runTimeToken.substring("LOCAL.DATE.TODAY:".length());
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(formatPattern);
                    paramaMap.put(runTimeToken, LocalDate.now().format(formatter));
                } else if (runTimeToken.startsWith("LOCAL.DATETIME.NOW:")) {
                    String formatPattern = runTimeToken.substring("LOCAL.DATETIME.NOW:".length());
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(formatPattern);
                    paramaMap.put(runTimeToken, LocalDateTime.now().format(formatter));
                } else if (runTimeToken.startsWith("XML.FILE:")) {
                    String xmlFileResource = runTimeToken.substring("XML.FILE:".length());
                    String xmlString = TokenUtils.getXmlContent(xmlFileResource);
                    paramaMap.put(runTimeToken, StringEscapeUtils.escapeJava((String)xmlString));
                } else if (runTimeToken.startsWith("RANDOM.UUID")) {
                    paramaMap.put(runTimeToken, UUID.randomUUID().toString());
                }
            }
        });
    }

    public static List<String> getTestCaseTokens(String aString) {
        Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher matcher = pattern.matcher(aString);
        ArrayList<String> keyTokens = new ArrayList<String>();
        while (matcher.find()) {
            keyTokens.add(matcher.group(1));
        }
        return keyTokens;
    }

    public static String createRandomAlphaString(int length) {
        StringBuilder builder = new StringBuilder();
        Random r = new Random();
        for (int i = 0; i < length; ++i) {
            builder.append((char)(97 + r.nextInt(26)));
        }
        String randomString = builder.toString();
        return randomString;
    }

    public static String createStaticAlphaString(int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append((char)(97 + i));
            i = i >= 26 ? 0 : i;
        }
        return builder.toString();
    }

    public static String getXmlContent(String xmlFileResource) {
        try {
            return SmartUtils.readJsonAsString(xmlFileResource);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Oops! Problem occurred while reading the XML file '" + xmlFileResource + "', details:" + e);
        }
    }
}

