/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.runner.parallel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jsmart.zerocode.core.domain.LoadWith;
import org.jsmart.zerocode.core.domain.TestMapping;
import org.jsmart.zerocode.core.runner.parallel.LoadProcessor;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCodeMultiLoadRunner
extends ParentRunner<TestMapping[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodeMultiLoadRunner.class);
    public static final String LOAD_LABEL = "<<Multi-Load>>";
    private final Class<?> testClass;
    private LoadProcessor loadProcessor;
    private String loadPropertiesFile;
    private Description testDescription;

    public ZeroCodeMultiLoadRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        this.testClass = testClass;
        this.loadPropertiesFile = this.validateAndGetLoadPropertiesFile();
        this.loadProcessor = new LoadProcessor(this.loadPropertiesFile);
    }

    protected List<TestMapping[]> getChildren() {
        this.validateAnnotationPresence();
        this.validateTestMethod();
        return this.getTestMappingsArrayAsSingleElementList();
    }

    private List<TestMapping[]> getTestMappingsArrayAsSingleElementList() {
        TestMapping[] testMappings = (TestMapping[])this.testClass.getAnnotationsByType(TestMapping.class);
        ArrayList<TestMapping[]> testMappingsSingleElementList = new ArrayList<TestMapping[]>();
        testMappingsSingleElementList.add(testMappings);
        return testMappingsSingleElementList;
    }

    protected Description describeChild(TestMapping[] childArrayElement) {
        String multiLoadLabel = this.createMultiLoadLabel(childArrayElement);
        System.out.println("### label = " + multiLoadLabel + "\n");
        this.testDescription = Description.createTestDescription(this.testClass, (String)(LOAD_LABEL + multiLoadLabel));
        return this.testDescription;
    }

    protected void runChild(TestMapping[] childArrayElement, RunNotifier notifier) {
        notifier.fireTestStarted(this.testDescription);
        Arrays.stream(childArrayElement).forEach(thisChild -> this.loadProcessor.addTest(thisChild.testClass(), thisChild.testMethod()));
        boolean hasFailed = this.loadProcessor.processMultiLoad();
        if (hasFailed) {
            String failureMessage = this.testClass.getName() + " with load/stress test(s): " + this.testDescription + " have Failed";
            LOGGER.error(failureMessage + ". See target/logs -or- junit granular failure report(csv) -or- fuzzy search and filter report(html) for details");
            notifier.fireTestFailure(new Failure(this.testDescription, (Throwable)new RuntimeException(failureMessage)));
        }
        notifier.fireTestFinished(this.testDescription);
    }

    public void run(RunNotifier notifier) {
        super.run(notifier);
    }

    private String validateAndGetLoadPropertiesFile() {
        LoadWith loadWithAnno = this.testClass.getAnnotation(LoadWith.class);
        if (loadWithAnno == null) {
            throw new RuntimeException("Ah! You missed to put the @LoadWith(...) on the load-generating test class >> " + this.testClass.getName());
        }
        return loadWithAnno.value();
    }

    private void validateAnnotationPresence() {
        TestMapping[] testMappings = (TestMapping[])this.testClass.getAnnotationsByType(TestMapping.class);
        if (testMappings.length == 0) {
            throw new RuntimeException("Ah! You missed to put the @TestMapping on the load-generating test class >>" + this.testClass.getName() + ".");
        }
    }

    private void validateTestMethod() {
        TestMapping[] testMappings = (TestMapping[])this.testClass.getAnnotationsByType(TestMapping.class);
        Arrays.stream(testMappings).forEach(methodMapping -> {
            String errMessage = " was invalid, please re-check and pick the correct test method to load.";
            try {
                errMessage = "Mapped test method `" + methodMapping.testMethod() + "`" + errMessage;
                methodMapping.testClass().getMethod(methodMapping.testMethod(), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error(errMessage);
                throw new RuntimeException(errMessage + e);
            }
        });
    }

    private String createMultiLoadLabel(TestMapping[] childArrayElement) {
        AtomicInteger counter = new AtomicInteger(0);
        return Arrays.stream(childArrayElement).map(thisChild -> "\n" + counter.incrementAndGet() + ")" + thisChild.testClass().getSimpleName() + "." + thisChild.testMethod()).collect(Collectors.joining(",")) + "\n";
    }
}

