/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.runner.parallel;

import java.util.Arrays;
import java.util.List;
import org.jsmart.zerocode.core.domain.LoadWith;
import org.jsmart.zerocode.core.domain.TestMapping;
import org.jsmart.zerocode.core.runner.parallel.LoadProcessor;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCodeLoadRunner
extends ParentRunner<TestMapping> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodeLoadRunner.class);
    public static final String LOAD_LABEL = "<<Load>>";
    private final Class<?> testClass;
    private LoadProcessor loadProcessor;
    private String loadPropertiesFile;
    private Description testDescription;

    public ZeroCodeLoadRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        this.testClass = testClass;
        this.loadPropertiesFile = this.validateAndGetLoadPropertiesFile();
        this.loadProcessor = new LoadProcessor(this.loadPropertiesFile);
    }

    protected List<TestMapping> getChildren() {
        this.validateAnnotationPresence();
        this.validateTestMethod();
        return Arrays.asList(this.testClass.getAnnotationsByType(TestMapping.class));
    }

    protected Description describeChild(TestMapping child) {
        this.testDescription = Description.createTestDescription(this.testClass, (String)(LOAD_LABEL + child.testMethod()));
        return this.testDescription;
    }

    protected void runChild(TestMapping child, RunNotifier notifier) {
        notifier.fireTestStarted(this.testDescription);
        boolean hasFailed = this.loadProcessor.addTest(child.testClass(), child.testMethod()).process();
        if (hasFailed) {
            String failureMessage = this.testClass.getName() + "." + child.testMethod() + " Failed";
            LOGGER.error(failureMessage + ". See target/logs -or- junit granular failure report(csv) -or- fuzzy search and filter report(html) for details");
            notifier.fireTestFailure(new Failure(this.testDescription, (Throwable)new RuntimeException(failureMessage)));
        }
        notifier.fireTestFinished(this.testDescription);
    }

    public void run(RunNotifier notifier) {
        super.run(notifier);
    }

    private String validateAndGetLoadPropertiesFile() {
        LoadWith loadWithAnno = this.testClass.getAnnotation(LoadWith.class);
        if (loadWithAnno == null) {
            throw new RuntimeException("Ah! You missed to put the @LoadWith(...) on the load-generating test class >> " + this.testClass.getName());
        }
        return loadWithAnno.value();
    }

    private void validateAnnotationPresence() {
        TestMapping methodMapping = this.testClass.getAnnotation(TestMapping.class);
        TestMapping[] testMappings = (TestMapping[])this.testClass.getAnnotationsByType(TestMapping.class);
        if (testMappings.length > 1) {
            throw new RuntimeException("Oops! Needs single @TestMapping, but found multiple of it on the load-generating test class >>" + this.testClass.getName() + ". \n For running multiple tests as load use @RunWith(ZeroCodeMultiLoadRunner.class)");
        }
        if (methodMapping == null) {
            throw new RuntimeException("Ah! You missed to put the @TestMapping on the load-generating test class >> " + this.testClass.getName());
        }
    }

    private void validateTestMethod() {
        String errMessage = " was invalid, please re-check and pick the correct test method to load.";
        try {
            TestMapping methodMapping = this.testClass.getAnnotation(TestMapping.class);
            errMessage = "Mapped test method `" + methodMapping.testMethod() + "`" + errMessage;
            methodMapping.testClass().getMethod(methodMapping.testMethod(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error(errMessage);
            throw new RuntimeException(errMessage + e);
        }
    }
}

