/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.runner;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jsmart.zerocode.core.di.main.ApplicationMainModule;
import org.jsmart.zerocode.core.di.module.RuntimeHttpClientModule;
import org.jsmart.zerocode.core.di.module.RuntimeKafkaClientModule;
import org.jsmart.zerocode.core.domain.HostProperties;
import org.jsmart.zerocode.core.domain.JsonTestCase;
import org.jsmart.zerocode.core.domain.ScenarioSpec;
import org.jsmart.zerocode.core.domain.TargetEnv;
import org.jsmart.zerocode.core.domain.UseHttpClient;
import org.jsmart.zerocode.core.domain.UseKafkaClient;
import org.jsmart.zerocode.core.domain.builders.ZeroCodeExecResultBuilder;
import org.jsmart.zerocode.core.domain.builders.ZeroCodeReportBuilder;
import org.jsmart.zerocode.core.engine.listener.ZeroCodeTestReportListener;
import org.jsmart.zerocode.core.httpclient.BasicHttpClient;
import org.jsmart.zerocode.core.httpclient.ssl.SslTrustHttpClient;
import org.jsmart.zerocode.core.kafka.client.BasicKafkaClient;
import org.jsmart.zerocode.core.kafka.client.ZerocodeCustomKafkaClient;
import org.jsmart.zerocode.core.logbuilder.LogCorrelationshipPrinter;
import org.jsmart.zerocode.core.report.ZeroCodeReportGenerator;
import org.jsmart.zerocode.core.runner.ZeroCodeMultiStepsScenarioRunner;
import org.jsmart.zerocode.core.runner.ZeroCodeMultiStepsScenarioRunnerImpl;
import org.jsmart.zerocode.core.utils.RunnerUtils;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCodeUnitRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodeUnitRunner.class);
    private ZeroCodeMultiStepsScenarioRunner zeroCodeMultiStepsScenarioRunner;
    private final Class<?> testClass;
    private Injector injector;
    private SmartUtils smartUtils;
    private HostProperties hostProperties;
    private String host;
    private String context;
    private int port;
    private List<String> smartTestCaseNames = new ArrayList<String>();
    private String currentTestCase;
    private LogCorrelationshipPrinter logCorrelationshipPrinter;
    protected boolean testRunCompleted;
    protected boolean passed;
    private ZeroCodeMultiStepsScenarioRunner multiStepsRunner;

    public ZeroCodeUnitRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.testClass = klass;
        this.smartUtils = this.getInjectedSmartUtilsClass();
        this.smartTestCaseNames = this.getSmartChildrenList();
        this.hostProperties = this.testClass.getAnnotation(HostProperties.class);
        if (this.hostProperties != null) {
            this.host = this.hostProperties.host();
            this.port = this.hostProperties.port();
            this.context = this.hostProperties.context();
        }
        this.multiStepsRunner = this.createZeroCodeMultiStepRunner();
    }

    public void run(RunNotifier notifier) {
        ZeroCodeTestReportListener reportListener = new ZeroCodeTestReportListener(this.smartUtils.getMapper(), this.getInjectedReportGenerator());
        LOGGER.info("System property zerocode.junit=" + System.getProperty("zerocode.junit"));
        if (!"gen-smart-charts-csv-reports".equals(System.getProperty("zerocode.junit"))) {
            notifier.addListener((RunListener)reportListener);
        }
        super.run(notifier);
        this.handleNoRunListenerReport(reportListener);
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        JsonTestCase annotation = method.getMethod().getAnnotation(JsonTestCase.class);
        if (this.isIgnored(method)) {
            notifier.fireTestIgnored(description);
        } else if (annotation != null) {
            this.runLeafJsonTest(notifier, description, annotation);
        } else {
            this.runLeafJUnitTest(this.methodBlock(method), description, notifier);
        }
    }

    public List<String> getSmartTestCaseNames() {
        return this.smartTestCaseNames;
    }

    public String getCurrentTestCase() {
        return this.currentTestCase;
    }

    private ZeroCodeMultiStepsScenarioRunner getInjectedMultiStepsRunner() {
        this.zeroCodeMultiStepsScenarioRunner = (ZeroCodeMultiStepsScenarioRunner)this.getMainModuleInjector().getInstance(ZeroCodeMultiStepsScenarioRunner.class);
        return this.zeroCodeMultiStepsScenarioRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Injector getMainModuleInjector() {
        ZeroCodeUnitRunner zeroCodeUnitRunner = this;
        synchronized (zeroCodeUnitRunner) {
            TargetEnv envAnnotation = this.testClass.getAnnotation(TargetEnv.class);
            String serverEnv = envAnnotation != null ? envAnnotation.value() : "config_hosts.properties";
            serverEnv = RunnerUtils.getEnvSpecificConfigFile(serverEnv, this.testClass);
            Class<? extends BasicHttpClient> runtimeHttpClient = this.getCustomHttpClientOrDefault();
            Class<? extends BasicKafkaClient> runtimeKafkaClient = this.getCustomKafkaClientOrDefault();
            this.injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new ApplicationMainModule(serverEnv)}).with(new Module[]{new RuntimeHttpClientModule(runtimeHttpClient), new RuntimeKafkaClientModule(runtimeKafkaClient)})});
            return this.injector;
        }
    }

    private Class<? extends BasicKafkaClient> getCustomKafkaClientOrDefault() {
        UseKafkaClient kafkaClientAnnotated = this.testClass.getAnnotation(UseKafkaClient.class);
        return kafkaClientAnnotated != null ? kafkaClientAnnotated.value() : ZerocodeCustomKafkaClient.class;
    }

    private Class<? extends BasicHttpClient> getCustomHttpClientOrDefault() {
        UseHttpClient httpClientAnnotated = this.testClass.getAnnotation(UseHttpClient.class);
        return httpClientAnnotated != null ? httpClientAnnotated.value() : SslTrustHttpClient.class;
    }

    protected SmartUtils getInjectedSmartUtilsClass() {
        return (SmartUtils)this.getMainModuleInjector().getInstance(SmartUtils.class);
    }

    protected ZeroCodeReportGenerator getInjectedReportGenerator() {
        return (ZeroCodeReportGenerator)this.getMainModuleInjector().getInstance(ZeroCodeReportGenerator.class);
    }

    private void runLeafJsonTest(RunNotifier notifier, Description description, JsonTestCase annotation) {
        if (annotation != null) {
            this.currentTestCase = annotation.value();
        }
        notifier.fireTestStarted(description);
        LOGGER.debug("### Running currentTestCase : " + this.currentTestCase);
        ScenarioSpec child = null;
        try {
            child = this.smartUtils.jsonFileToJava(this.currentTestCase, ScenarioSpec.class);
            LOGGER.debug("### Found currentTestCase : -" + child);
            this.passed = this.multiStepsRunner.runScenario(child, notifier, description);
        }
        catch (Exception ioEx) {
            ioEx.printStackTrace();
            notifier.fireTestFailure(new Failure(description, (Throwable)ioEx));
        }
        this.testRunCompleted = true;
        if (this.passed) {
            LOGGER.info(String.format("\n**FINISHED executing all Steps for [%s] **.\nSteps were:%s", child.getScenarioName(), child.getSteps().stream().map(step -> step.getName()).collect(Collectors.toList())));
        }
        notifier.fireTestFinished(description);
    }

    private List<String> getSmartChildrenList() {
        List children = this.getChildren();
        children.forEach(frameworkMethod -> {
            JsonTestCase annotation = (JsonTestCase)frameworkMethod.getAnnotation(JsonTestCase.class);
            if (annotation != null) {
                this.smartTestCaseNames.add(annotation.value());
            } else {
                this.smartTestCaseNames.add(frameworkMethod.getName());
            }
        });
        return this.smartTestCaseNames;
    }

    private ZeroCodeMultiStepsScenarioRunner createZeroCodeMultiStepRunner() {
        ZeroCodeMultiStepsScenarioRunner multiStepsRunner = this.getInjectedMultiStepsRunner();
        if (this.hostProperties != null) {
            ((ZeroCodeMultiStepsScenarioRunnerImpl)multiStepsRunner).overrideHost(this.host);
            ((ZeroCodeMultiStepsScenarioRunnerImpl)multiStepsRunner).overridePort(this.port);
            ((ZeroCodeMultiStepsScenarioRunnerImpl)multiStepsRunner).overrideApplicationContext(this.context);
        }
        return multiStepsRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runLeafJUnitTest(Statement statement, Description description, RunNotifier notifier) {
        LOGGER.info("Running a pure JUnit test...");
        EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
        eachNotifier.fireTestStarted();
        String logPrefixRelationshipId = this.prepareRequestReport(description);
        try {
            statement.evaluate();
            this.passed = true;
            LOGGER.info("JUnit test passed = {} ", (Object)this.passed);
        }
        catch (AssumptionViolatedException e) {
            this.passed = false;
            LOGGER.warn("JUnit test failed due to : {},  passed = {}", (Object)e, (Object)this.passed);
            eachNotifier.addFailedAssumption(e);
        }
        catch (Throwable e) {
            this.passed = false;
            LOGGER.warn("JUnit test failed due to : {},  passed = {}", (Object)e, (Object)this.passed);
            eachNotifier.addFailure(e);
        }
        finally {
            LOGGER.info("JUnit test run completed. See the results in the console or log.  passed = {}", (Object)this.passed);
            this.prepareResponseReport(logPrefixRelationshipId);
            this.buildReportAndPrintToFile(description);
            eachNotifier.fireTestFinished();
        }
    }

    private void buildReportAndPrintToFile(Description description) {
        ZeroCodeExecResultBuilder reportResultBuilder = ZeroCodeExecResultBuilder.newInstance().loop(0).scenarioName(description.getClassName());
        reportResultBuilder.step(this.logCorrelationshipPrinter.buildReportSingleStep());
        ZeroCodeReportBuilder reportBuilder = ZeroCodeReportBuilder.newInstance().timeStamp(LocalDateTime.now());
        reportBuilder.result(reportResultBuilder.build());
        reportBuilder.printToFile(description.getClassName() + this.logCorrelationshipPrinter.getCorrelationId() + ".json");
    }

    private void prepareResponseReport(String logPrefixRelationshipId) {
        LocalDateTime timeNow = LocalDateTime.now();
        LOGGER.info("JUnit *responseTimeStamp:{}, \nJUnit Response:{}", (Object)timeNow, (Object)logPrefixRelationshipId);
        this.logCorrelationshipPrinter.aResponseBuilder().relationshipId(logPrefixRelationshipId).responseTimeStamp(timeNow);
        this.logCorrelationshipPrinter.result(this.passed);
        this.logCorrelationshipPrinter.buildResponseDelay();
    }

    private String prepareRequestReport(Description description) {
        this.logCorrelationshipPrinter = LogCorrelationshipPrinter.newInstance(LOGGER);
        this.logCorrelationshipPrinter.stepLoop(0);
        String logPrefixRelationshipId = this.logCorrelationshipPrinter.createRelationshipId();
        LocalDateTime timeNow = LocalDateTime.now();
        this.logCorrelationshipPrinter.aRequestBuilder().stepLoop(0).relationshipId(logPrefixRelationshipId).requestTimeStamp(timeNow).step(description.getMethodName());
        LOGGER.info("JUnit *requestTimeStamp:{}, \nJUnit Request:{}", (Object)timeNow, (Object)logPrefixRelationshipId);
        return logPrefixRelationshipId;
    }

    private void handleNoRunListenerReport(ZeroCodeTestReportListener reportListener) {
        if ("gen-smart-charts-csv-reports".equals(System.getProperty("zerocode.junit"))) {
            LOGGER.debug("Bypassed JUnit RunListener [as configured by the build tool] to generate useful reports...");
            reportListener.testRunFinished(new Result());
        }
    }
}

