/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.runner;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.List;
import java.util.stream.Collectors;
import org.jsmart.zerocode.core.di.main.ApplicationMainModule;
import org.jsmart.zerocode.core.di.module.RuntimeHttpClientModule;
import org.jsmart.zerocode.core.domain.ScenarioSpec;
import org.jsmart.zerocode.core.domain.TargetEnv;
import org.jsmart.zerocode.core.domain.TestPackageRoot;
import org.jsmart.zerocode.core.domain.UseHttpClient;
import org.jsmart.zerocode.core.engine.listener.ZeroCodeTestReportListener;
import org.jsmart.zerocode.core.httpclient.ssl.SslTrustHttpClient;
import org.jsmart.zerocode.core.report.ZeroCodeReportGenerator;
import org.jsmart.zerocode.core.runner.ZeroCodeMultiStepsScenarioRunner;
import org.jsmart.zerocode.core.utils.RunnerUtils;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCodePackageRunner
extends ParentRunner<ScenarioSpec> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodePackageRunner.class);
    private final Class<?> testClass;
    private List<ScenarioSpec> scenarioSpecs;
    private Injector injector;
    private SmartUtils smartUtils;
    protected Description scenarioDescription;
    protected boolean isRunSuccess;
    protected boolean passed;
    protected boolean testRunCompleted;
    private ZeroCodeMultiStepsScenarioRunner zeroCodeMultiStepsScenarioRunner;

    public ZeroCodePackageRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        this.testClass = testClass;
        this.zeroCodeMultiStepsScenarioRunner = this.getInjectedMultiStepsRunner();
        this.smartUtils = this.getInjectedSmartUtilsClass();
    }

    protected SmartUtils getInjectedSmartUtilsClass() {
        return (SmartUtils)this.getInjector().getInstance(SmartUtils.class);
    }

    @Inject
    public ZeroCodePackageRunner(Class<?> testClass, SmartUtils smartUtils) throws InitializationError {
        super(testClass);
        this.testClass = testClass;
        this.smartUtils = smartUtils;
    }

    protected List<ScenarioSpec> getChildren() {
        TestPackageRoot rootPackageAnnotation = this.testClass.getAnnotation(TestPackageRoot.class);
        if (rootPackageAnnotation == null) {
            throw new RuntimeException("Ah! Almost there. Just missing root package details.\ne.g. Annotate your Test class now, e.g. @TestPackageRoot(\"resource_folder_for_test_cases\")");
        }
        this.smartUtils.checkDuplicateScenarios(rootPackageAnnotation.value());
        return this.smartUtils.getScenarioSpecListByPackage(rootPackageAnnotation.value());
    }

    protected Description describeChild(ScenarioSpec child) {
        this.scenarioDescription = Description.createTestDescription(this.testClass, (String)child.getScenarioName());
        return this.scenarioDescription;
    }

    public void run(RunNotifier notifier) {
        ZeroCodeTestReportListener reportListener = new ZeroCodeTestReportListener(this.smartUtils.getMapper(), this.getInjectedReportGenerator());
        notifier.addListener((RunListener)reportListener);
        LOGGER.info("System property zerocode.junit=" + System.getProperty("zerocode.junit"));
        if (!"gen-smart-charts-csv-reports".equals(System.getProperty("zerocode.junit"))) {
            notifier.addListener((RunListener)reportListener);
        }
        super.run(notifier);
        this.handleNoRunListenerReport(reportListener);
    }

    protected void runChild(ScenarioSpec child, RunNotifier notifier) {
        Description description = Description.createTestDescription(this.testClass, (String)child.getScenarioName());
        notifier.fireTestStarted(description);
        this.passed = this.zeroCodeMultiStepsScenarioRunner.runScenario(child, notifier, description);
        this.testRunCompleted = true;
        if (this.passed) {
            LOGGER.info(String.format("\nPackageRunner- **FINISHED executing all Steps for [%s] **.\nSteps were:%s", child.getScenarioName(), child.getSteps().stream().map(step -> step.getName()).collect(Collectors.toList())));
        }
        notifier.fireTestFinished(description);
    }

    public Injector getInjector() {
        TargetEnv envAnnotation = this.testClass.getAnnotation(TargetEnv.class);
        String serverEnv = envAnnotation != null ? envAnnotation.value() : "config_hosts.properties";
        serverEnv = RunnerUtils.getEnvSpecificConfigFile(serverEnv, this.testClass);
        UseHttpClient runtimeClientAnnotated = this.testClass.getAnnotation(UseHttpClient.class);
        Class runtimeHttpClient = runtimeClientAnnotated != null ? runtimeClientAnnotated.value() : SslTrustHttpClient.class;
        return Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new ApplicationMainModule(serverEnv)}).with(new Module[]{new RuntimeHttpClientModule(runtimeHttpClient)})});
    }

    public void setSmartUtils(SmartUtils smartUtils) {
        this.smartUtils = smartUtils;
    }

    public boolean isRunSuccess() {
        return this.isRunSuccess;
    }

    public boolean isPassed() {
        return this.passed;
    }

    public boolean isTestRunCompleted() {
        return this.testRunCompleted;
    }

    public void setZeroCodeMultiStepsScenarioRunner(ZeroCodeMultiStepsScenarioRunner zeroCodeMultiStepsScenarioRunner) {
        this.zeroCodeMultiStepsScenarioRunner = zeroCodeMultiStepsScenarioRunner;
    }

    private ZeroCodeMultiStepsScenarioRunner getInjectedMultiStepsRunner() {
        this.zeroCodeMultiStepsScenarioRunner = (ZeroCodeMultiStepsScenarioRunner)this.getInjector().getInstance(ZeroCodeMultiStepsScenarioRunner.class);
        return this.zeroCodeMultiStepsScenarioRunner;
    }

    private ZeroCodeReportGenerator getInjectedReportGenerator() {
        return (ZeroCodeReportGenerator)this.getInjector().getInstance(ZeroCodeReportGenerator.class);
    }

    private void handleNoRunListenerReport(ZeroCodeTestReportListener reportListener) {
        if ("gen-smart-charts-csv-reports".equals(System.getProperty("zerocode.junit"))) {
            LOGGER.debug("Bypassed JUnit RunListener [as configured by the build tool] to generate useful reports...");
            reportListener.testRunFinished(new Result());
        }
    }
}

