/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.runner;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.jsmart.zerocode.core.engine.assertion.AssertionReport;
import org.jsmart.zerocode.core.runner.Notifier;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepNotificationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(StepNotificationHandler.class);
    private final int MAX_LINE_LENGTH = 130;

    Boolean handleAssertionFailed(RunNotifier notifier, Description description, String scenarioName, String stepName, List<AssertionReport> failureReportList) {
        LOGGER.error(String.format("Failed assertion during Scenario:%s, --> Step:%s, Details: %s\n", scenarioName, stepName, StringUtils.join(failureReportList, (String)"\n")));
        String prettyFailureMessage = String.format("Assertion failed for :- \n\n[%s] \n\t|\n\t|\n\t+---Step --> [%s] \n\nFailures:\n--------- %n%s%n", scenarioName, stepName, StringUtils.join(failureReportList, (String)("\n" + this.deckedUpLine(this.maxEntryLengthOf(failureReportList)) + "\n")));
        LOGGER.error(prettyFailureMessage + "(See below 'Actual Vs Expected' to learn why this step failed) \n");
        notifier.fireTestFailure(new Failure(description, (Throwable)new RuntimeException(prettyFailureMessage)));
        return false;
    }

    Boolean handleStepException(RunNotifier notifier, Description description, String scenarioName, String stepName, Exception stepException) {
        LOGGER.info(String.format("Exception occurred while executing Scenario:[%s], --> Step:[%s], Details: %s", scenarioName, stepName, stepException));
        notifier.fireTestFailure(new Failure(description, (Throwable)stepException));
        return false;
    }

    Boolean handleAssertionPassed(RunNotifier notifier, Description description, String scenarioName, String stepName, List<AssertionReport> failureReportList) {
        LOGGER.info(String.format("\n***Step PASSED:%s->%s", scenarioName, stepName));
        return true;
    }

    public <A, B, C, D, E, R> R handleAssertion(A var1, B var2, C var3, D var4, E var5, Notifier<A, B, C, D, E, R> notifyFunc) {
        R result = notifyFunc.apply(var1, var2, var3, var4, var5);
        return result;
    }

    private int maxEntryLengthOf(List<AssertionReport> failureReportList) {
        Integer maxLength = Optional.ofNullable(failureReportList).orElse(Collections.emptyList()).stream().map(report -> report.toString().length()).max(Comparator.naturalOrder()).get();
        return maxLength > 130 ? 130 : maxLength;
    }

    private String deckedUpLine(int stringLength) {
        String DECKED_CHAR = "-";
        String dottedlLine = "";
        for (int i = 0; i < stringLength; ++i) {
            dottedlLine = dottedlLine + "-";
        }
        return dottedlLine;
    }
}

