/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.kafka.helper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.jsmart.zerocode.core.di.provider.GsonSerDeProvider;
import org.jsmart.zerocode.core.di.provider.ObjectMapperProvider;
import org.jsmart.zerocode.core.kafka.consume.ConsumerLocalConfigs;
import org.jsmart.zerocode.core.kafka.receive.message.ConsumerJsonRecord;

public class KafkaFileRecordHelper {
    private static final Gson gson = new GsonSerDeProvider().get();
    private static final ObjectMapper objectMapper = new ObjectMapperProvider().get();

    public static void handleRecordsDump(ConsumerLocalConfigs consumeLocalTestProps, List<ConsumerRecord> rawRecords, List<ConsumerJsonRecord> jsonRecords) {
        String recordType;
        String string = recordType = consumeLocalTestProps != null ? consumeLocalTestProps.getRecordType() : null;
        if (recordType != null) {
            switch (recordType) {
                case "RAW": {
                    KafkaFileRecordHelper.dumpRawRecordsIfEnabled(consumeLocalTestProps.getFileDumpTo(), rawRecords);
                    break;
                }
                case "JSON": {
                    KafkaFileRecordHelper.dumpJsonRecordsIfEnabled(consumeLocalTestProps.getFileDumpTo(), jsonRecords);
                    break;
                }
                case "BIN": {
                    break;
                }
                case "HEX": {
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported recordType - '" + recordType + "'");
                }
            }
        }
    }

    public static void dumpRawRecordsIfEnabled(String fileName, List<ConsumerRecord> fetchedRecords) {
        if (fileName != null) {
            File file = KafkaFileRecordHelper.createCascadeIfNotExisting(fileName);
            try {
                FileWriter writer = new FileWriter(file.getAbsoluteFile());
                for (ConsumerRecord thisRecord : fetchedRecords) {
                    writer.write(gson.toJson((Object)thisRecord) + KafkaFileRecordHelper.osIndependentNewLine());
                }
                writer.close();
            }
            catch (IOException exx) {
                throw new RuntimeException("Could not write to file '" + fileName + "' exception >> " + exx);
            }
        }
    }

    public static void dumpJsonRecordsIfEnabled(String fileName, List<ConsumerJsonRecord> fetchedRecords) {
        if (fileName != null) {
            File file = KafkaFileRecordHelper.createCascadeIfNotExisting(fileName);
            try {
                FileWriter writer = new FileWriter(file.getAbsoluteFile());
                for (ConsumerJsonRecord thisRecord : fetchedRecords) {
                    writer.write(objectMapper.writeValueAsString((Object)thisRecord) + KafkaFileRecordHelper.osIndependentNewLine());
                }
                writer.close();
            }
            catch (IOException exx) {
                throw new RuntimeException("Could not write to file '" + fileName + "', exception was >> " + exx);
            }
        }
    }

    private static File createCascadeIfNotExisting(String fileName) {
        try {
            Path path = Paths.get(fileName, new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            File file = new File(fileName);
            return file;
        }
        catch (IOException exx) {
            throw new RuntimeException("Create file '" + fileName + "' Exception" + exx);
        }
    }

    private static String osIndependentNewLine() {
        return System.getProperty("line.separator");
    }
}

