/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.httpclient.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlQueryParamsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlQueryParamsUtils.class);

    public static String setQueryParams(String httpUrl, Map<String, Object> queryParams) throws IOException {
        String qualifiedQueryParams = UrlQueryParamsUtils.createQualifiedQueryParams(queryParams);
        httpUrl = httpUrl + "?" + qualifiedQueryParams;
        LOGGER.info("### Effective url is : " + httpUrl);
        return httpUrl;
    }

    protected static String createQualifiedQueryParams(Map<String, Object> queryParamsMap) throws IOException {
        queryParamsMap = Optional.ofNullable(queryParamsMap).orElse(new HashMap());
        ArrayList<BasicNameValuePair> nameValueList = new ArrayList<BasicNameValuePair>();
        for (String key : queryParamsMap.keySet()) {
            nameValueList.add(new BasicNameValuePair(key, queryParamsMap.get(key).toString()));
        }
        UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(nameValueList);
        String qualifiedQueryParam = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
        LOGGER.info("### qualifiedQueryParams : " + qualifiedQueryParam);
        return qualifiedQueryParam;
    }
}

