/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.engine.executor;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.jsmart.zerocode.core.engine.executor.JavaExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaExecutorImpl
implements JavaExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaExecutorImpl.class);
    private final Injector injector;

    @Inject
    public JavaExecutorImpl(Injector injector) {
        this.injector = injector;
    }

    @Override
    public Object execute(String qualifiedClassName, String methodName, Object ... args) {
        try {
            return this.findMethod(qualifiedClassName, methodName).invoke(this.injector.getInstance(this.getClass(qualifiedClassName)), args);
        }
        catch (Exception e) {
            LOGGER.error("Exception encountered while executing java method" + e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Class<?>> argumentTypes(String className, String methodName) {
        return Arrays.asList(this.findMethod(className, methodName).getParameterTypes());
    }

    private Method findMethod(String className, String methodName) {
        Method[] declaredMethods;
        Class<?> type = this.getClass(className);
        for (Method declared : declaredMethods = type.getDeclaredMethods()) {
            if (!declared.getName().equals(methodName)) continue;
            return declared;
        }
        throw new RuntimeException(String.format("Java: Could not find method %s in class %s", methodName, className));
    }

    private Class<?> getClass(String className) {
        Class<?> type;
        try {
            type = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return type;
    }
}

