/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.engine.assertion;

import org.jsmart.zerocode.core.engine.assertion.AssertionReport;
import org.jsmart.zerocode.core.engine.assertion.JsonAsserter;

public class FieldHasSubStringIgnoreCaseValueAsserter
implements JsonAsserter {
    private final String path;
    private final String expected;

    public FieldHasSubStringIgnoreCaseValueAsserter(String path, String expected) {
        this.path = path;
        this.expected = expected;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public AssertionReport actualEqualsToExpected(Object result) {
        boolean areEqual;
        if (result instanceof String && this.expected instanceof String) {
            String s1 = (String)result;
            String s2 = this.expected;
            areEqual = s1.toUpperCase().contains(s2.toUpperCase());
        } else {
            areEqual = false;
        }
        return areEqual ? AssertionReport.createFieldMatchesReport() : AssertionReport.createFieldDoesNotMatchReport(this.path, "containing sub-string with ignoring case:" + this.expected, result);
    }
}

