/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jruby.compiler.ir.IR_Class;
import org.jruby.compiler.ir.operands.Nil;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Array
extends Operand {
    public final Operand[] _elts;

    public Array() {
        this._elts = new Operand[0];
    }

    public Array(List<Operand> elts) {
        this(elts.toArray(new Operand[elts.size()]));
    }

    public Array(Operand[] elts) {
        this._elts = elts == null ? new Operand[]{} : elts;
    }

    public boolean isBlank() {
        return this._elts.length == 0;
    }

    public String toString() {
        return "Array:" + (this.isBlank() ? "" : Arrays.toString(this._elts));
    }

    @Override
    public boolean isConstant() {
        for (Operand o : this._elts) {
            if (o.isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNonAtomicValue() {
        return true;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap) {
        for (int i = 0; i < this._elts.length; ++i) {
            this._elts[i] = this._elts[i].getSimplifiedOperand(valueMap);
        }
        return this;
    }

    @Override
    public Operand fetchCompileTimeArrayElement(int argIndex, boolean getSubArray) {
        if (!getSubArray) {
            return argIndex < this._elts.length ? this._elts[argIndex] : Nil.NIL;
        }
        if (argIndex < this._elts.length) {
            Operand[] newElts = new Operand[this._elts.length - argIndex];
            System.arraycopy(this._elts, argIndex, newElts, 0, newElts.length);
            return new Array(newElts);
        }
        return new Array();
    }

    @Override
    public IR_Class getTargetClass() {
        return IR_Class.getCoreClass("Array");
    }

    public Operand toArray() {
        return this;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        for (Operand o : this._elts) {
            o.addUsedVariables(l);
        }
    }
}

