
package org.dmg.pmml.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.jpmml.model.annotations.Removed;
import org.jpmml.model.annotations.Required;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "ClusteringModel", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "localTransformations",
    "comparisonMeasure",
    "clusteringFields",
    "centerFields",
    "missingValueWeights",
    "clusters",
    "modelVerification"
})
@JsonRootName("ClusteringModel")
@JsonPropertyOrder({
    "modelName",
    "miningFunction",
    "algorithmName",
    "modelClass",
    "numberOfClusters",
    "scorable",
    "mathContext",
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "localTransformations",
    "comparisonMeasure",
    "clusteringFields",
    "centerFields",
    "missingValueWeights",
    "clusters",
    "modelVerification"
})
public class ClusteringModel
    extends Model
    implements HasExtensions<ClusteringModel>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "modelClass", required = true)
    @JsonProperty("modelClass")
    private ClusteringModel.ModelClass modelClass;
    @XmlAttribute(name = "numberOfClusters", required = true)
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfClusters")
    private Integer numberOfClusters;
    @XmlAttribute(name = "isScorable")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("isScorable")
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.XPMML))
    @JsonProperty("x-mathContext")
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Output")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "ComparisonMeasure", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("ComparisonMeasure")
    private ComparisonMeasure comparisonMeasure;
    @XmlElement(name = "ClusteringField", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @Required((org.dmg.pmml.Version.PMML_4_2))
    @JsonProperty("ClusteringField")
    private List<ClusteringField> clusteringFields;
    @XmlElement(name = "CenterFields", namespace = "http://www.dmg.org/PMML-4_4")
    @Removed((org.dmg.pmml.Version.PMML_3_2))
    @JsonProperty("CenterFields")
    private CenterFields centerFields;
    @XmlElement(name = "MissingValueWeights", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("MissingValueWeights")
    private MissingValueWeights missingValueWeights;
    @XmlElement(name = "Cluster", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Cluster")
    private List<Cluster> clusters;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelVerification")
    private ModelVerification modelVerification;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67371268L;

    public ClusteringModel() {
    }

    @ValueConstructor
    public ClusteringModel(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("modelClass")
        ClusteringModel.ModelClass modelClass,
        @org.jpmml.model.annotations.Property("numberOfClusters")
        Integer numberOfClusters,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("comparisonMeasure")
        ComparisonMeasure comparisonMeasure,
        @org.jpmml.model.annotations.Property("clusteringFields")
        List<ClusteringField> clusteringFields,
        @org.jpmml.model.annotations.Property("clusters")
        List<Cluster> clusters) {
        this.miningFunction = miningFunction;
        this.modelClass = modelClass;
        this.numberOfClusters = numberOfClusters;
        this.miningSchema = miningSchema;
        this.comparisonMeasure = comparisonMeasure;
        this.clusteringFields = clusteringFields;
        this.clusters = clusters;
    }

    public String getModelName() {
        return modelName;
    }

    public ClusteringModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    public ClusteringModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public ClusteringModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public ClusteringModel.ModelClass getModelClass() {
        return modelClass;
    }

    public ClusteringModel setModelClass(
        @org.jpmml.model.annotations.Property("modelClass")
        ClusteringModel.ModelClass modelClass) {
        this.modelClass = modelClass;
        return this;
    }

    public Integer getNumberOfClusters() {
        return numberOfClusters;
    }

    public ClusteringModel setNumberOfClusters(
        @org.jpmml.model.annotations.Property("numberOfClusters")
        Integer numberOfClusters) {
        this.numberOfClusters = numberOfClusters;
        return this;
    }

    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    public ClusteringModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    public ClusteringModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ClusteringModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    public ClusteringModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    public Output getOutput() {
        return output;
    }

    public ClusteringModel setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    public ModelStats getModelStats() {
        return modelStats;
    }

    public ClusteringModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    public ClusteringModel setModelExplanation(
        @org.jpmml.model.annotations.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public ClusteringModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public ComparisonMeasure getComparisonMeasure() {
        return comparisonMeasure;
    }

    public ClusteringModel setComparisonMeasure(
        @org.jpmml.model.annotations.Property("comparisonMeasure")
        ComparisonMeasure comparisonMeasure) {
        this.comparisonMeasure = comparisonMeasure;
        return this;
    }

    public boolean hasClusteringFields() {
        return ((this.clusteringFields!= null)&&(this.clusteringFields.size()> 0));
    }

    public List<ClusteringField> getClusteringFields() {
        if (clusteringFields == null) {
            clusteringFields = new ArrayList<ClusteringField>();
        }
        return this.clusteringFields;
    }

    public ClusteringModel addClusteringFields(ClusteringField... clusteringFields) {
        getClusteringFields().addAll(Arrays.asList(clusteringFields));
        return this;
    }

    public CenterFields getCenterFields() {
        return centerFields;
    }

    public ClusteringModel setCenterFields(
        @org.jpmml.model.annotations.Property("centerFields")
        CenterFields centerFields) {
        this.centerFields = centerFields;
        return this;
    }

    public MissingValueWeights getMissingValueWeights() {
        return missingValueWeights;
    }

    public ClusteringModel setMissingValueWeights(
        @org.jpmml.model.annotations.Property("missingValueWeights")
        MissingValueWeights missingValueWeights) {
        this.missingValueWeights = missingValueWeights;
        return this;
    }

    public boolean hasClusters() {
        return ((this.clusters!= null)&&(this.clusters.size()> 0));
    }

    public List<Cluster> getClusters() {
        if (clusters == null) {
            clusters = new ArrayList<Cluster>();
        }
        return this.clusters;
    }

    public ClusteringModel addClusters(Cluster... clusters) {
        getClusters().addAll(Arrays.asList(clusters));
        return this;
    }

    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    public ClusteringModel setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getLocalTransformations(), getComparisonMeasure());
            }
            if ((status == VisitorAction.CONTINUE)&&hasClusteringFields()) {
                status = PMMLObject.traverse(visitor, getClusteringFields());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getCenterFields(), getMissingValueWeights());
            }
            if ((status == VisitorAction.CONTINUE)&&hasClusters()) {
                status = PMMLObject.traverse(visitor, getClusters());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum ModelClass
        implements StringValue<ClusteringModel.ModelClass>
    {

        @XmlEnumValue("centerBased")
        @JsonProperty("centerBased")
        CENTER_BASED("centerBased"),
        @XmlEnumValue("distributionBased")
        @JsonProperty("distributionBased")
        DISTRIBUTION_BASED("distributionBased");
        private final String value;

        ModelClass(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static ClusteringModel.ModelClass fromValue(String v) {
            for (ClusteringModel.ModelClass c: ClusteringModel.ModelClass.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
