
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;

@XmlType(name = "MATH-CONTEXT", namespace = "http://www.dmg.org/PMML-4_4")
@XmlEnum
public enum MathContext
    implements StringValue<MathContext>
{

    @XmlEnumValue("float")
    @JsonProperty("float")
    FLOAT("float"),
    @XmlEnumValue("double")
    @JsonProperty("double")
    DOUBLE("double");
    private final String value;

    MathContext(String v) {
        value = v;
    }

    @Override
    public String value() {
        return value;
    }

    public static MathContext fromValue(String v) {
        for (MathContext c: MathContext.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    @Override
    public String toString() {
        return value();
    }

}
