/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.camel;

import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.Injector;
import org.jooby.Managed;
import org.jooby.internal.camel.GuiceInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelFinalizer
implements Managed {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private DefaultCamelContext ctx;
    private ProducerTemplate producer;
    private ConsumerTemplate consumer;

    @Inject
    public CamelFinalizer(GuiceInjector injector, DefaultCamelContext ctx, @Named(value="camel.routes") Set<Object> routes, RouteBuilder rb, ProducerTemplate producer, ConsumerTemplate consumer) throws Exception {
        this.ctx = ctx;
        this.producer = producer;
        this.consumer = consumer;
        this.ctx.setInjector((Injector)injector);
        for (Object route : routes) {
            if (!(route instanceof RoutesBuilder)) continue;
            this.ctx.addRoutes((RoutesBuilder)route);
        }
        this.ctx.addRoutes((RoutesBuilder)rb);
    }

    public void start() throws Exception {
        this.ctx.start();
        this.producer.start();
        this.consumer.start();
    }

    public void stop() throws Exception {
        try {
            this.consumer.stop();
        }
        catch (Exception ex) {
            this.log.error("Can't stop consumer template", (Throwable)ex);
        }
        try {
            this.producer.stop();
        }
        catch (Exception ex) {
            this.log.error("Can't stop producer template", (Throwable)ex);
        }
        try {
            this.ctx.stop();
        }
        catch (Exception ex) {
            this.log.error("Can't stop camel context template", (Throwable)ex);
        }
    }
}

