/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.camel;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.ThreadPoolProfile;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.internal.camel.CamelFinalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Camel
implements Jooby.Module {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Configurer<CamelContext> configurer;
    private Configurer<RouteBuilder> routes;
    private List<Class<?>> routeList = new ArrayList();

    public Camel routes(Class<?> routeClass) {
        this.routeList.add(routeClass);
        return this;
    }

    public Camel doWith(Configurer<CamelContext> configurer) {
        this.configurer = Objects.requireNonNull(configurer, "A configurer is required.");
        return this;
    }

    public Camel routes(Configurer<RouteBuilder> routes) {
        this.routes = Objects.requireNonNull(routes, "Route configurer is required.");
        return this;
    }

    public void configure(Env env, Config config, Binder binder) {
        Config $camel = config.getConfig("camel");
        DefaultCamelContext ctx = this.configure(new DefaultCamelContext(), $camel.withoutPath("shutdown").withoutPath("threads").withoutPath("jmx").withoutPath("streamCaching"));
        if (!$camel.getBoolean("jmx")) {
            ctx.disableJMX();
        }
        ThreadPoolProfile threadPool = this.configure(new ThreadPoolProfile(), $camel.getConfig("threads"));
        ctx.getExecutorServiceManager().setDefaultThreadPoolProfile(threadPool);
        this.configure(ctx.getShutdownStrategy(), $camel.getConfig("shutdown"));
        if ($camel.getBoolean("streamCaching.enabled")) {
            ctx.setStreamCaching(Boolean.valueOf(true));
            this.configure(ctx.getStreamCachingStrategy(), $camel.getConfig("streamCaching"));
        } else {
            ctx.setStreamCaching(Boolean.valueOf(false));
        }
        if (this.configurer != null) {
            try {
                this.configurer.configure((CamelContext)ctx, config);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Context configurer resulted in error", ex);
            }
        }
        if (this.routes != null) {
            try {
                Camel.routes(this.routes, ctx, config);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Route builder resulted in error", ex);
            }
        }
        PropertiesComponent properties = new PropertiesComponent(config.root().origin().description());
        properties.setIgnoreMissingLocation(true);
        properties.setPropertiesResolver((context, ignoreMissingLocation, location) -> {
            Properties props = new Properties();
            config.entrySet().forEach(e -> props.setProperty((String)e.getKey(), ((ConfigValue)e.getValue()).unwrapped().toString()));
            return props;
        });
        properties.setPrefixToken("${");
        properties.setSuffixToken("}");
        ctx.addComponent("properties", (Component)properties);
        binder.bind(CamelContext.class).toInstance((Object)ctx);
        binder.bind(DefaultCamelContext.class).toInstance((Object)ctx);
        binder.bind(ProducerTemplate.class).toInstance((Object)ctx.createProducerTemplate());
        binder.bind(ConsumerTemplate.class).toInstance((Object)ctx.createConsumerTemplate());
        binder.bind(CamelFinalizer.class).asEagerSingleton();
        binder.bind(RouteBuilder.class).toInstance((Object)Camel.rb());
        Multibinder routesBinder = Multibinder.newSetBinder((Binder)binder, Object.class, (Annotation)Names.named((String)"camel.routes"));
        this.routeList.forEach(routeType -> routesBinder.addBinding().to(routeType));
    }

    private static RouteBuilder rb() {
        return new RouteBuilder(){

            public void configure() throws Exception {
            }
        };
    }

    private static void routes(final Configurer<RouteBuilder> callback, DefaultCamelContext ctx, final Config config) throws Exception {
        ctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                callback.configure(this, config);
            }
        });
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"camel.conf");
    }

    private <T> T configure(T source, Config config) {
        ArrayList methods = Lists.newArrayList((Object[])source.getClass().getMethods());
        config.entrySet().forEach(o -> {
            String key = (String)o.getKey();
            String setter = "set" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, key);
            Object value = ((ConfigValue)o.getValue()).unwrapped();
            Optional<Method> result = methods.stream().filter(m -> m.getName().equals(setter)).findFirst();
            if (result.isPresent()) {
                Method method = result.get();
                Class<?> type = method.getParameterTypes()[0];
                if (Enum.class.isAssignableFrom(type)) {
                    value = Enum.valueOf(type, value.toString());
                }
                if (Long.class.isAssignableFrom(type)) {
                    value = ((Number)value).longValue();
                }
                if (File.class.isAssignableFrom(type)) {
                    value = new File(value.toString());
                }
                try {
                    method.invoke(source, value);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Bad option: <" + value + "> for: " + method, ex);
                }
            } else {
                this.log.error("Unknown option camel.{} = {}", (Object)key, value);
            }
        });
        return source;
    }

    public static interface Configurer<T> {
        public void configure(T var1, Config var2) throws Exception;
    }
}

