// SECTION-START[License Header]
// <editor-fold defaultstate="collapsed" desc=" Generated License ">
/*
 *   Java Object Management and Configuration
 *   Copyright (C) Christian Schulte, 2011-313
 *   All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *
 *     o Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *
 *     o Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 *   INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 *   AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 *   THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *   NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *   THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *   $JOMC: RuntimeTexts.java 4381 2012-03-04 19:29:29Z schulte2005 $
 *
 */
// </editor-fold>
// SECTION-END
package org.jomc.ri.model;

import java.util.Map;
import javax.xml.bind.annotation.XmlTransient;
import org.jomc.model.Text;
import org.jomc.model.Texts;
import static org.jomc.ri.model.RuntimeModelObjects.createMap;

// SECTION-START[Documentation]
// <editor-fold defaultstate="collapsed" desc=" Generated Documentation ">
/**
 * Runtime {@code Texts}.
 *
 * <dl>
 *   <dt><b>Identifier:</b></dt><dd>org.jomc.ri.model.RuntimeTexts</dd>
 *   <dt><b>Name:</b></dt><dd>JOMC RI RuntimeTexts</dd>
 *   <dt><b>Specifications:</b></dt>
 *     <dd>org.jomc.ri.model.RuntimeModelObject @ 1.2</dd>
 *   <dt><b>Abstract:</b></dt><dd>No</dd>
 *   <dt><b>Final:</b></dt><dd>No</dd>
 *   <dt><b>Stateless:</b></dt><dd>No</dd>
 * </dl>
 *
 * @author <a href="mailto:schulte2005@users.sourceforge.net">Christian Schulte</a> 1.2
 * @version 1.2
 */
// </editor-fold>
// SECTION-END
// SECTION-START[Annotations]
// <editor-fold defaultstate="collapsed" desc=" Generated Annotations ">
@javax.annotation.Generated( value = "org.jomc.tools.SourceFileProcessor 1.2.2", comments = "See http://jomc.sourceforge.net/jomc/1.2/jomc-tools-1.2.2" )
// </editor-fold>
// SECTION-END
public class RuntimeTexts extends Texts implements RuntimeModelObject
{
    // SECTION-START[RuntimeTexts]

    /** Cache map. */
    @XmlTransient
    private transient final Map<String, Text> textsByLanguageCache = createMap();

    /**
     * Creates a new {@code RuntimeTexts} instance by deeply copying a given {@code Texts} instance.
     *
     * @param texts The instance to copy.
     *
     * @throws NullPointerException if {@code texts} is {@code null}.
     */
    public RuntimeTexts( final Texts texts )
    {
        super( texts );
        this.copyTexts();
    }

    /**
     * Gets a text for a given language from the list of texts.
     * <p>This method queries an internal cache for a result object to return for the given argument values. If no
     * cached result object is available, this method queries the super-class for a result object to return and caches
     * the outcome of that query for use on successive calls.</p>
     * <p><b>Note:</b><br/>Method {@code clear()} must be used to synchronize the state of the internal cache with the
     * state of the instance, should the state of the instance change.</p>
     *
     * @param language The language of the text to return.
     *
     * @return The first matching text or the default text, if no such text is found.
     *
     * @throws NullPointerException if {@code language} is {@code null}.
     *
     * @see #getText()
     * @see #getDefaultLanguage()
     * @see Text#getLanguage()
     * @see #clear()
     */
    @Override
    public Text getText( final String language )
    {
        if ( language == null )
        {
            throw new NullPointerException( "language" );
        }

        synchronized ( this.textsByLanguageCache )
        {
            Text t = this.textsByLanguageCache.get( language );

            if ( t == null && !this.textsByLanguageCache.containsKey( language ) )
            {
                t = super.getText( language );
                this.textsByLanguageCache.put( language, t );
            }

            return t;
        }
    }

    private void copyTexts()
    {
        for ( int i = 0, s0 = this.getText().size(); i < s0; i++ )
        {
            final Text t = this.getText().get( i );
            this.getText().set( i, RuntimeModelObjects.getInstance().copyOf( t ) );
        }
    }

    // SECTION-END
    // SECTION-START[RuntimeModelObject]
    public void gc()
    {
        this.gcOrClear( true, false );
    }

    public void clear()
    {
        synchronized ( this.textsByLanguageCache )
        {
            this.textsByLanguageCache.clear();
        }

        this.gcOrClear( false, true );
    }

    private void gcOrClear( final boolean gc, final boolean clear )
    {
        this.gcOrClearTexts( gc, clear );
    }

    private void gcOrClearTexts( final boolean gc, final boolean clear )
    {
        for ( int i = 0, s0 = this.getText().size(); i < s0; i++ )
        {
            final Text t = this.getText().get( i );
            if ( t instanceof RuntimeModelObject )
            {
                if ( gc )
                {
                    ( (RuntimeModelObject) t ).gc();
                }
                if ( clear )
                {
                    ( (RuntimeModelObject) t ).clear();
                }
            }
        }
    }
    // SECTION-END
    // SECTION-START[Constructors]
    // <editor-fold defaultstate="collapsed" desc=" Generated Constructors ">
    /** Creates a new {@code RuntimeTexts} instance. */
    @javax.annotation.Generated( value = "org.jomc.tools.SourceFileProcessor 1.2.2", comments = "See http://jomc.sourceforge.net/jomc/1.2/jomc-tools-1.2.2" )
    public RuntimeTexts()
    {
        // SECTION-START[Default Constructor]
        super();
        // SECTION-END
    }
    // </editor-fold>
    // SECTION-END
    // SECTION-START[Dependencies]
    // SECTION-END
    // SECTION-START[Properties]
    // SECTION-END
    // SECTION-START[Messages]
    // SECTION-END
}
