/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.modlet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.xml.bind.JAXBElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelValidationReport
implements Serializable {
    private static final long serialVersionUID = 6688024709865043122L;
    private List<Detail> details;

    public List<Detail> getDetails() {
        if (this.details == null) {
            this.details = new ArrayList<Detail>();
        }
        return this.details;
    }

    public List<Detail> getDetails(String identifier) {
        ArrayList<Detail> list = new ArrayList<Detail>(this.getDetails().size());
        for (Detail d : this.getDetails()) {
            if (identifier == null && d.getIdentifier() == null) {
                list.add(d);
            }
            if (identifier == null || !identifier.equals(d.getIdentifier())) continue;
            list.add(d);
        }
        return Collections.unmodifiableList(list);
    }

    public boolean isModelValid() {
        for (Detail d : this.getDetails()) {
            if (d.getLevel() == null || d.getLevel().intValue() <= Level.WARNING.intValue()) continue;
            return false;
        }
        return true;
    }

    public static class Detail
    implements Serializable {
        private static final long serialVersionUID = -2466230076806042116L;
        private String identifier;
        private Level level;
        private String message;
        private JAXBElement element;

        public Detail(String identifier, Level level, String message, JAXBElement element) {
            this.identifier = identifier;
            this.level = level;
            this.message = message;
            this.element = element;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public Level getLevel() {
            return this.level;
        }

        public String getMessage() {
            return this.message;
        }

        public JAXBElement getElement() {
            return this.element;
        }

        private String toStringInternal() {
            return '{' + "identifier=" + this.getIdentifier() + ", level=" + this.getLevel().getLocalizedName() + ", message=" + this.getMessage() + ", element=" + this.getElement() + '}';
        }

        public String toString() {
            return super.toString() + this.toStringInternal();
        }
    }
}

