/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.modlet;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import javax.xml.validation.Validator;
import org.jomc.modlet.DefaultModelContext;
import org.jomc.modlet.Model;
import org.jomc.modlet.ModelException;
import org.jomc.modlet.ModelValidationReport;
import org.jomc.modlet.Modlet;
import org.jomc.modlet.Modlets;
import org.jomc.modlet.ObjectFactory;
import org.jomc.modlet.Schema;
import org.jomc.modlet.Schemas;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelContext {
    private static final String DEFAULT_MODLET_SCHEMA_SYSTEM_ID = "http://jomc.sourceforge.net/modlet/jomc-modlet-1.0.xsd";
    private static final Level DEFAULT_LOG_LEVEL = Level.WARNING;
    private static volatile Level defaultLogLevel;
    private static volatile String defaultModletSchemaSystemId;
    private static volatile String modelContextClassName;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private ClassLoader classLoader;
    private List<Listener> listeners;
    private Level logLevel;
    private Modlets modlets;
    private String modletSchemaSystemId;

    public ModelContext(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.attributes.get(name);
    }

    public Object getAttribute(String name, Object def) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Object value = this.getAttribute(name);
        if (value == null) {
            value = def;
        }
        return value;
    }

    public Object setAttribute(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.attributes.put(name, value);
    }

    public void clearAttribute(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.attributes.remove(name);
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = new ClassLoader(null){

                public String toString() {
                    return ModelContext.class.getName() + ".BootstrapClassLoader@" + System.identityHashCode(this);
                }
            };
        }
        return this.classLoader;
    }

    public List<Listener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new LinkedList<Listener>();
        }
        return this.listeners;
    }

    public static String getDefaultModletSchemaSystemId() {
        if (defaultModletSchemaSystemId == null) {
            defaultModletSchemaSystemId = System.getProperty("org.jomc.modlet.ModelContext.defaultModletSchemaSystemId", DEFAULT_MODLET_SCHEMA_SYSTEM_ID);
        }
        return defaultModletSchemaSystemId;
    }

    public static void setDefaultModletSchemaSystemId(String value) {
        defaultModletSchemaSystemId = value;
    }

    public final String getModletSchemaSystemId() {
        if (this.modletSchemaSystemId == null) {
            this.modletSchemaSystemId = ModelContext.getDefaultModletSchemaSystemId();
            this.log(Level.CONFIG, ModelContext.getMessage("defaultModletSchemaSystemIdInfo", this.getClass().getCanonicalName(), this.modletSchemaSystemId), null);
        }
        return this.modletSchemaSystemId;
    }

    public final void setModletSchemaSystemId(String value) {
        this.modletSchemaSystemId = value;
    }

    public static Level getDefaultLogLevel() {
        if (defaultLogLevel == null) {
            defaultLogLevel = Level.parse(System.getProperty("org.jomc.modlet.ModelContext.defaultLogLevel", DEFAULT_LOG_LEVEL.getName()));
        }
        return defaultLogLevel;
    }

    public static void setDefaultLogLevel(Level value) {
        defaultLogLevel = value;
    }

    public final Level getLogLevel() {
        if (this.logLevel == null) {
            this.logLevel = ModelContext.getDefaultLogLevel();
            this.log(Level.CONFIG, ModelContext.getMessage("defaultLogLevelInfo", this.getClass().getCanonicalName(), this.logLevel.getLocalizedName()), null);
        }
        return this.logLevel;
    }

    public final void setLogLevel(Level value) {
        this.logLevel = value;
    }

    public boolean isLoggable(Level level) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        return level.intValue() >= this.getLogLevel().intValue();
    }

    public void log(Level level, String message, Throwable throwable) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        if (this.isLoggable(level)) {
            for (Listener l : this.getListeners()) {
                l.onLog(level, message, throwable);
            }
        }
    }

    public Modlets getModlets() throws ModelException {
        try {
            if (this.modlets == null) {
                Modlet modlet = new Modlet();
                modlet.setName(ModelContext.getMessage("projectName", new Object[0]));
                modlet.setVendor(ModelContext.getMessage("projectVendor", new Object[0]));
                modlet.setVersion(ModelContext.getMessage("projectVersion", new Object[0]));
                modlet.setSchemas(new Schemas());
                Schema schema = new Schema();
                schema.setPublicId("http://jomc.org/modlet");
                schema.setSystemId(this.getModletSchemaSystemId());
                schema.setContextId(this.getClass().getPackage().getName());
                schema.setClasspathId(this.getClass().getPackage().getName().replace('.', '/') + "/jomc-modlet-1.0.xsd");
                modlet.getSchemas().getSchema().add(schema);
                this.modlets = new Modlets();
                this.modlets.getModlet().add(modlet);
                Modlets provided = this.findModlets();
                for (Modlet m : provided.getModlet()) {
                    if (this.modlets.getModlet(m.getName()) != null) continue;
                    this.modlets.getModlet().add(m);
                }
                javax.xml.validation.Schema modletSchema = this.createSchema("http://jomc.org/modlet");
                Validator validator = modletSchema.newValidator();
                validator.validate((Source)new JAXBSource(this.createContext("http://jomc.org/modlet"), new ObjectFactory().createModlets(this.modlets)));
            }
            return this.modlets;
        }
        catch (IOException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (JAXBException e) {
            String message = e.getMessage();
            if (message == null && e.getLinkedException() != null) {
                message = e.getLinkedException().getMessage();
            }
            throw new ModelException(message, e);
        }
        catch (SAXException e) {
            String message = e.getMessage();
            if (message == null && e.getException() != null) {
                message = e.getException().getMessage();
            }
            throw new ModelException(message, e);
        }
    }

    public void setModlets(Modlets value) {
        this.modlets = value;
    }

    public static String getModelContextClassName() {
        if (modelContextClassName == null) {
            modelContextClassName = System.getProperty("org.jomc.modlet.ModelContext.className", DefaultModelContext.class.getName());
        }
        return modelContextClassName;
    }

    public static void setModelContextClassName(String value) {
        modelContextClassName = value;
    }

    public Class<?> findClass(String name) throws ModelException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        try {
            return Class.forName(name, true, this.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            if (this.isLoggable(Level.FINE)) {
                this.log(Level.FINE, e.getMessage(), e);
            }
            return null;
        }
    }

    public URL findResource(String name) throws ModelException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.getClassLoader().getResource(name);
    }

    public Enumeration<URL> findResources(String name) throws ModelException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        try {
            return this.getClassLoader().getResources(name);
        }
        catch (IOException e) {
            throw new ModelException(e.getMessage(), e);
        }
    }

    public abstract Modlets findModlets() throws ModelException;

    public static ModelContext createModelContext(ClassLoader classLoader) throws ModelException {
        if (DefaultModelContext.class.getName().equals(ModelContext.getModelContextClassName())) {
            return new DefaultModelContext(classLoader);
        }
        try {
            Class<?> clazz = Class.forName(ModelContext.getModelContextClassName(), true, classLoader);
            Constructor<ModelContext> ctor = clazz.asSubclass(ModelContext.class).getDeclaredConstructor(ClassLoader.class);
            return ctor.newInstance(classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new ModelException(ModelContext.getMessage("contextClassNotFound", ModelContext.getModelContextClassName()), e);
        }
        catch (NoSuchMethodException e) {
            throw new ModelException(ModelContext.getMessage("contextConstructorNotFound", ModelContext.getModelContextClassName()), e);
        }
        catch (InstantiationException e) {
            throw new ModelException(ModelContext.getMessage("contextInstantiationException", ModelContext.getModelContextClassName(), e.getMessage() != null ? " " + e.getMessage() : ""), e);
        }
        catch (IllegalAccessException e) {
            throw new ModelException(ModelContext.getMessage("contextConstructorAccessDenied", ModelContext.getModelContextClassName(), e.getMessage() != null ? " " + e.getMessage() : ""), e);
        }
        catch (InvocationTargetException e) {
            String message = e.getMessage();
            if (e.getTargetException() != null && e.getMessage() != null) {
                message = e.getTargetException().getMessage();
            }
            throw new ModelException(ModelContext.getMessage("contextConstructorException", ModelContext.getModelContextClassName(), message != null ? " " + message : ""), e);
        }
        catch (ClassCastException e) {
            throw new ModelException(ModelContext.getMessage("illegalContextImplementation", ModelContext.getModelContextClassName(), ModelContext.class.getName()), e);
        }
    }

    public abstract Model findModel(String var1) throws ModelException;

    public abstract EntityResolver createEntityResolver(String var1) throws ModelException;

    public abstract LSResourceResolver createResourceResolver(String var1) throws ModelException;

    public abstract javax.xml.validation.Schema createSchema(String var1) throws ModelException;

    public abstract JAXBContext createContext(String var1) throws ModelException;

    public abstract Marshaller createMarshaller(String var1) throws ModelException;

    public abstract Unmarshaller createUnmarshaller(String var1) throws ModelException;

    public abstract Model processModel(Model var1) throws ModelException;

    public abstract ModelValidationReport validateModel(Model var1) throws ModelException;

    public abstract ModelValidationReport validateModel(String var1, Source var2) throws ModelException;

    private static String getMessage(String key, Object ... args) {
        return MessageFormat.format(ResourceBundle.getBundle(ModelContext.class.getName().replace('.', '/'), Locale.getDefault()).getString(key), args);
    }

    public static abstract class Listener {
        public abstract void onLog(Level var1, String var2, Throwable var3);
    }
}

