/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.modlet;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jomc.modlet.ModelContext;
import org.jomc.modlet.ModelException;
import org.jomc.modlet.Modlet;
import org.jomc.modlet.ModletProvider;
import org.jomc.modlet.Modlets;

public class DefaultModletProvider
implements ModletProvider {
    private static final String DEFAULT_MODLET_LOCATION = "META-INF/jomc-modlet.xml";
    private static volatile String defaultModletLocation;
    private static volatile Boolean defaultEnabled;
    private Boolean enabled;
    private String modletLocation;

    public static boolean isDefaultEnabled() {
        if (defaultEnabled == null) {
            defaultEnabled = Boolean.valueOf(System.getProperty("org.jomc.modlet.DefaultModletProvider.defaultEnabled", Boolean.toString(true)));
        }
        return defaultEnabled;
    }

    public static void setDefaultEnabled(Boolean value) {
        defaultEnabled = value;
    }

    public final boolean isEnabled() {
        if (this.enabled == null) {
            this.enabled = DefaultModletProvider.isDefaultEnabled();
        }
        return this.enabled;
    }

    public final void setEnabled(Boolean value) {
        this.enabled = value;
    }

    public static String getDefaultModletLocation() {
        if (defaultModletLocation == null) {
            defaultModletLocation = System.getProperty("org.jomc.modlet.DefaultModletProvider.defaultModletLocation", DEFAULT_MODLET_LOCATION);
        }
        return defaultModletLocation;
    }

    public static void setDefaultModletLocation(String value) {
        defaultModletLocation = value;
    }

    public final String getModletLocation() {
        if (this.modletLocation == null) {
            this.modletLocation = DefaultModletProvider.getDefaultModletLocation();
        }
        return this.modletLocation;
    }

    public final void setModletLocation(String value) {
        this.modletLocation = value;
    }

    public Modlets findModlets(ModelContext context, String location) throws ModelException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (location == null) {
            throw new NullPointerException("location");
        }
        try {
            Modlets modlets = null;
            long t0 = System.currentTimeMillis();
            JAXBContext ctx = context.createContext("http://jomc.org/modlet");
            Unmarshaller u = ctx.createUnmarshaller();
            Enumeration<URL> e = context.findResources(location);
            u.setSchema(context.createSchema("http://jomc.org/modlet"));
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                Object content = u.unmarshal(url);
                if (content instanceof JAXBElement) {
                    content = ((JAXBElement)content).getValue();
                }
                if (content instanceof Modlet) {
                    if (modlets == null) {
                        modlets = new Modlets();
                    }
                    modlets.getModlet().add((Modlet)content);
                    continue;
                }
                if (!(content instanceof Modlets)) continue;
                if (modlets == null) {
                    modlets = new Modlets();
                }
                for (Modlet m : ((Modlets)content).getModlet()) {
                    modlets.getModlet().add(m);
                }
            }
            if (context.isLoggable(Level.CONFIG)) {
                context.log(Level.CONFIG, DefaultModletProvider.getMessage("contextReport", this.getClass().getName(), modlets != null ? modlets.getModlet().size() : 0, location, System.currentTimeMillis() - t0), null);
            }
            return modlets == null || modlets.getModlet().isEmpty() ? null : modlets;
        }
        catch (JAXBException e) {
            String message = e.getMessage();
            if (message == null && e.getLinkedException() != null) {
                message = e.getLinkedException().getMessage();
            }
            throw new ModelException(message, e);
        }
    }

    public Modlets findModlets(ModelContext context) throws ModelException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        return this.isEnabled() ? this.findModlets(context, this.getModletLocation()) : null;
    }

    private static String getMessage(String key, Object ... arguments) {
        return MessageFormat.format(ResourceBundle.getBundle(DefaultModletProvider.class.getName().replace('.', '/')).getString(key), arguments);
    }
}

