/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.modlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jomc.modlet.Model;
import org.jomc.modlet.ModelContext;
import org.jomc.modlet.ModelErrorHandler;
import org.jomc.modlet.ModelException;
import org.jomc.modlet.ModelProcessor;
import org.jomc.modlet.ModelProvider;
import org.jomc.modlet.ModelValidationReport;
import org.jomc.modlet.ModelValidator;
import org.jomc.modlet.Modlet;
import org.jomc.modlet.ModletProvider;
import org.jomc.modlet.Modlets;
import org.jomc.modlet.Schema;
import org.jomc.modlet.Schemas;
import org.jomc.modlet.Service;
import org.jomc.modlet.Services;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelContext
extends ModelContext {
    private static final String[] SCHEMA_EXTENSIONS = new String[]{"xsd"};
    private static final String DEFAULT_PROVIDER_LOCATION = "META-INF/services";
    private static final String DEFAULT_PLATFORM_PROVIDER_LOCATION = System.getProperty("java.home") + File.separator + "lib" + File.separator + "jomc.properties";
    private static volatile String defaultProviderLocation;
    private static volatile String defaultPlatformProviderLocation;
    private Reference<Set<URI>> cachedSchemaResources = new SoftReference<Object>(null);
    private String providerLocation;
    private String platformProviderLocation;

    public DefaultModelContext(ClassLoader classLoader) {
        super(classLoader);
    }

    public static String getDefaultProviderLocation() {
        if (defaultProviderLocation == null) {
            defaultProviderLocation = System.getProperty("org.jomc.modlet.DefaultModelContext.defaultProviderLocation", DEFAULT_PROVIDER_LOCATION);
        }
        return defaultProviderLocation;
    }

    public static void setDefaultProviderLocation(String value) {
        defaultProviderLocation = value;
    }

    public final String getProviderLocation() {
        if (this.providerLocation == null) {
            this.providerLocation = DefaultModelContext.getDefaultProviderLocation();
            this.log(Level.CONFIG, DefaultModelContext.getMessage("defaultProviderLocationInfo", this.getClass().getName(), this.providerLocation), null);
        }
        return this.providerLocation;
    }

    public final void setProviderLocation(String value) {
        this.providerLocation = value;
    }

    public static String getDefaultPlatformProviderLocation() {
        if (defaultPlatformProviderLocation == null) {
            defaultPlatformProviderLocation = System.getProperty("org.jomc.modlet.DefaultModelContext.defaultPlatformProviderLocation", DEFAULT_PLATFORM_PROVIDER_LOCATION);
        }
        return defaultPlatformProviderLocation;
    }

    public static void setDefaultPlatformProviderLocation(String value) {
        defaultPlatformProviderLocation = value;
    }

    public final String getPlatformProviderLocation() {
        if (this.platformProviderLocation == null) {
            this.platformProviderLocation = DefaultModelContext.getDefaultPlatformProviderLocation();
            this.log(Level.CONFIG, DefaultModelContext.getMessage("defaultPlatformProviderLocationInfo", this.getClass().getName(), this.platformProviderLocation), null);
        }
        return this.platformProviderLocation;
    }

    public final void setPlatformProviderLocation(String value) {
        this.platformProviderLocation = value;
    }

    @Override
    public Modlets findModlets() throws ModelException {
        try {
            Modlets modlets = new Modlets();
            Collection<Class<ModletProvider>> providers = this.loadProviders(ModletProvider.class);
            for (Class<ModletProvider> provider : providers) {
                ModletProvider modletProvider = provider.newInstance();
                Modlets provided = modletProvider.findModlets(this);
                if (provided == null) continue;
                if (this.isLoggable(Level.FINE)) {
                    for (Modlet m : provided.getModlet()) {
                        this.log(Level.FINE, DefaultModelContext.getMessage("modletInfo", this.getClass().getName(), modletProvider.getClass().getName(), m.getName(), m.getModel(), m.getVendor() != null ? m.getVendor() : DefaultModelContext.getMessage("noVendor", new Object[0]), m.getVersion() != null ? m.getVersion() : DefaultModelContext.getMessage("noVersion", new Object[0])), null);
                        if (m.getSchemas() != null) {
                            for (Schema schema : m.getSchemas().getSchema()) {
                                this.log(Level.FINE, DefaultModelContext.getMessage("modletSchemaInfo", this.getClass().getName(), m.getName(), schema.getPublicId(), schema.getSystemId(), schema.getContextId() != null ? schema.getContextId() : DefaultModelContext.getMessage("noContext", new Object[0]), schema.getClasspathId() != null ? schema.getClasspathId() : DefaultModelContext.getMessage("noClasspathId", new Object[0])), null);
                            }
                        }
                        if (m.getServices() == null) continue;
                        for (Service service : m.getServices().getService()) {
                            this.log(Level.FINE, DefaultModelContext.getMessage("modletServiceInfo", this.getClass().getName(), m.getName(), service.getOrdinal(), service.getIdentifier(), service.getClazz()), null);
                        }
                    }
                }
                modlets.getModlet().addAll(provided.getModlet());
            }
            return modlets;
        }
        catch (InstantiationException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ModelException(e.getMessage(), e);
        }
    }

    @Override
    public Model findModel(String model) throws ModelException {
        if (model == null) {
            throw new NullPointerException("model");
        }
        try {
            Model m = new Model();
            m.setIdentifier(model);
            Services services = this.getModlets().getServices(model);
            if (services != null) {
                for (Service provider : services.getServices(ModelProvider.class)) {
                    Class<?> clazz = this.findClass(provider.getClazz());
                    if (clazz == null) {
                        throw new ModelException(DefaultModelContext.getMessage("serviceNotFound", provider.getOrdinal(), provider.getIdentifier(), provider.getClazz()));
                    }
                    if (!ModelProvider.class.isAssignableFrom(clazz)) {
                        throw new ModelException(DefaultModelContext.getMessage("illegalService", provider.getOrdinal(), provider.getIdentifier(), provider.getClazz(), ModelProvider.class.getName()));
                    }
                    Class<ModelProvider> modelProviderClass = clazz.asSubclass(ModelProvider.class);
                    ModelProvider modelProvider = modelProviderClass.newInstance();
                    Model provided = modelProvider.findModel(this, m);
                    if (provided == null) continue;
                    m = provided;
                }
            }
            return m;
        }
        catch (InstantiationException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ModelException(e.getMessage(), e);
        }
    }

    @Override
    public EntityResolver createEntityResolver(final String model) throws ModelException {
        if (model == null) {
            throw new NullPointerException("model");
        }
        final String logPrefix = this.getClass().getName();
        return new DefaultHandler(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                InputSource schemaSource;
                block19: {
                    if (systemId == null) {
                        throw new NullPointerException("systemId");
                    }
                    schemaSource = null;
                    try {
                        Schema s = null;
                        Schemas classpathSchemas = DefaultModelContext.this.getModlets().getSchemas(model);
                        if (classpathSchemas != null) {
                            if (publicId != null) {
                                s = classpathSchemas.getSchemaByPublicId(publicId);
                            }
                            if (s == null) {
                                s = classpathSchemas.getSchemaBySystemId(systemId);
                            }
                        }
                        if (s != null) {
                            schemaSource = new InputSource();
                            schemaSource.setPublicId(s.getPublicId() != null ? s.getPublicId() : publicId);
                            schemaSource.setSystemId(s.getSystemId());
                            if (s.getClasspathId() != null) {
                                URL resource = DefaultModelContext.this.findResource(s.getClasspathId());
                                if (resource != null) {
                                    schemaSource.setSystemId(resource.toExternalForm());
                                } else if (DefaultModelContext.this.isLoggable(Level.WARNING)) {
                                    DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("resourceNotFound", new Object[]{s.getClasspathId()}), null);
                                }
                            }
                            if (DefaultModelContext.this.isLoggable(Level.FINE)) {
                                DefaultModelContext.this.log(Level.FINE, DefaultModelContext.getMessage("resolutionInfo", new Object[]{logPrefix, publicId + ", " + systemId, schemaSource.getPublicId() + ", " + schemaSource.getSystemId()}), null);
                            }
                        }
                        if (schemaSource != null) break block19;
                        URI systemUri = new URI(systemId);
                        String schemaName = systemUri.getPath();
                        if (schemaName != null) {
                            int lastIndexOfSlash = schemaName.lastIndexOf(47);
                            if (lastIndexOfSlash != -1 && lastIndexOfSlash < schemaName.length()) {
                                schemaName = schemaName.substring(lastIndexOfSlash + 1);
                            }
                            for (URI uri : DefaultModelContext.this.getSchemaResources()) {
                                if (!uri.getPath().endsWith(schemaName)) continue;
                                schemaSource = new InputSource();
                                schemaSource.setPublicId(publicId);
                                schemaSource.setSystemId(uri.toASCIIString());
                                if (DefaultModelContext.this.isLoggable(Level.FINE)) {
                                    DefaultModelContext.this.log(Level.FINE, DefaultModelContext.getMessage("resolutionInfo", new Object[]{logPrefix, systemUri.toASCIIString(), schemaSource.getSystemId()}), null);
                                }
                                break block19;
                            }
                            break block19;
                        }
                        if (DefaultModelContext.this.isLoggable(Level.WARNING)) {
                            DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedSystemIdUri", new Object[]{systemId, systemUri.toASCIIString()}), null);
                        }
                        schemaSource = null;
                    }
                    catch (URISyntaxException e) {
                        if (DefaultModelContext.this.isLoggable(Level.WARNING)) {
                            DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedSystemIdUri", new Object[]{systemId, e.getMessage()}), null);
                        }
                        schemaSource = null;
                    }
                    catch (ModelException e) {
                        throw (IOException)new IOException(DefaultModelContext.getMessage("failedResolving", new Object[]{publicId, systemId, e.getMessage()})).initCause(e);
                    }
                }
                return schemaSource;
            }
        };
    }

    @Override
    public LSResourceResolver createResourceResolver(final String model) throws ModelException {
        if (model == null) {
            throw new NullPointerException("model");
        }
        return new LSResourceResolver(){

            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, final String baseURI) {
                block11: {
                    String resolvePublicId = namespaceURI == null ? publicId : namespaceURI;
                    String resolveSystemId = systemId == null ? "" : systemId;
                    try {
                        if ("http://www.w3.org/2001/XMLSchema".equals(type)) {
                            final InputSource schemaSource = DefaultModelContext.this.createEntityResolver(model).resolveEntity(resolvePublicId, resolveSystemId);
                            if (schemaSource != null) {
                                return new LSInput(){

                                    public Reader getCharacterStream() {
                                        return schemaSource.getCharacterStream();
                                    }

                                    public void setCharacterStream(Reader characterStream) {
                                        DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedOperation", new Object[]{"setCharacterStream", DefaultModelContext.class.getName() + ".LSResourceResolver"}), null);
                                    }

                                    public InputStream getByteStream() {
                                        return schemaSource.getByteStream();
                                    }

                                    public void setByteStream(InputStream byteStream) {
                                        DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedOperation", new Object[]{"setByteStream", DefaultModelContext.class.getName() + ".LSResourceResolver"}), null);
                                    }

                                    public String getStringData() {
                                        return null;
                                    }

                                    public void setStringData(String stringData) {
                                        DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedOperation", new Object[]{"setStringData", DefaultModelContext.class.getName() + ".LSResourceResolver"}), null);
                                    }

                                    public String getSystemId() {
                                        return schemaSource.getSystemId();
                                    }

                                    public void setSystemId(String systemId) {
                                        DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedOperation", new Object[]{"setSystemId", DefaultModelContext.class.getName() + ".LSResourceResolver"}), null);
                                    }

                                    public String getPublicId() {
                                        return schemaSource.getPublicId();
                                    }

                                    public void setPublicId(String publicId) {
                                        DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedOperation", new Object[]{"setPublicId", DefaultModelContext.class.getName() + ".LSResourceResolver"}), null);
                                    }

                                    public String getBaseURI() {
                                        return baseURI;
                                    }

                                    public void setBaseURI(String baseURI2) {
                                        DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedOperation", new Object[]{"setBaseURI", DefaultModelContext.class.getName() + ".LSResourceResolver"}), null);
                                    }

                                    public String getEncoding() {
                                        return schemaSource.getEncoding();
                                    }

                                    public void setEncoding(String encoding) {
                                        DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedOperation", new Object[]{"setEncoding", DefaultModelContext.class.getName() + ".LSResourceResolver"}), null);
                                    }

                                    public boolean getCertifiedText() {
                                        return false;
                                    }

                                    public void setCertifiedText(boolean certifiedText) {
                                        DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedOperation", new Object[]{"setCertifiedText", DefaultModelContext.class.getName() + ".LSResourceResolver"}), null);
                                    }
                                };
                            }
                        } else if (DefaultModelContext.this.isLoggable(Level.WARNING)) {
                            DefaultModelContext.this.log(Level.WARNING, DefaultModelContext.getMessage("unsupportedResourceType", new Object[]{type}), null);
                        }
                    }
                    catch (SAXException e) {
                        String message = e.getMessage();
                        if (message == null && e.getException() != null) {
                            message = e.getException().getMessage();
                        }
                        if (DefaultModelContext.this.isLoggable(Level.SEVERE)) {
                            DefaultModelContext.this.log(Level.SEVERE, DefaultModelContext.getMessage("failedResolving", new Object[]{resolvePublicId, resolveSystemId, message}), e);
                        }
                    }
                    catch (IOException e) {
                        if (DefaultModelContext.this.isLoggable(Level.SEVERE)) {
                            DefaultModelContext.this.log(Level.SEVERE, DefaultModelContext.getMessage("failedResolving", new Object[]{resolvePublicId, resolveSystemId, e.getMessage()}), e);
                        }
                    }
                    catch (ModelException e) {
                        if (!DefaultModelContext.this.isLoggable(Level.SEVERE)) break block11;
                        DefaultModelContext.this.log(Level.SEVERE, DefaultModelContext.getMessage("failedResolving", new Object[]{resolvePublicId, resolveSystemId, e.getMessage()}), e);
                    }
                }
                return null;
            }
        };
    }

    @Override
    public javax.xml.validation.Schema createSchema(String model) throws ModelException {
        if (model == null) {
            throw new NullPointerException("model");
        }
        try {
            SchemaFactory f = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schemas schemas = this.getModlets().getSchemas(model);
            EntityResolver entityResolver = this.createEntityResolver(model);
            ArrayList<SAXSource> sources = new ArrayList<SAXSource>(schemas != null ? schemas.getSchema().size() : 0);
            if (schemas != null) {
                for (Schema s : schemas.getSchema()) {
                    InputSource inputSource = entityResolver.resolveEntity(s.getPublicId(), s.getSystemId());
                    if (inputSource == null) continue;
                    sources.add(new SAXSource(inputSource));
                }
            }
            if (sources.isEmpty()) {
                throw new ModelException(DefaultModelContext.getMessage("missingSchemas", model));
            }
            f.setResourceResolver(this.createResourceResolver(model));
            f.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException e) throws SAXException {
                    if (DefaultModelContext.this.isLoggable(Level.WARNING)) {
                        DefaultModelContext.this.log(Level.WARNING, e.getMessage(), e);
                    }
                }

                public void error(SAXParseException e) throws SAXException {
                    throw e;
                }

                public void fatalError(SAXParseException e) throws SAXException {
                    throw e;
                }
            });
            return f.newSchema(sources.toArray(new Source[sources.size()]));
        }
        catch (IOException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (SAXException e) {
            String message = e.getMessage();
            if (message == null && e.getException() != null) {
                message = e.getException().getMessage();
            }
            throw new ModelException(message, e);
        }
    }

    @Override
    public JAXBContext createContext(String model) throws ModelException {
        if (model == null) {
            throw new NullPointerException("model");
        }
        try {
            StringBuilder packageNames = new StringBuilder();
            Schemas schemas = this.getModlets().getSchemas(model);
            if (schemas != null) {
                for (Schema schema : schemas.getSchema()) {
                    if (schema.getContextId() == null) continue;
                    packageNames.append(':').append(schema.getContextId());
                }
            }
            if (packageNames.length() == 0) {
                throw new ModelException(DefaultModelContext.getMessage("missingSchemas", model));
            }
            return JAXBContext.newInstance((String)packageNames.toString().substring(1), (ClassLoader)this.getClassLoader());
        }
        catch (JAXBException e) {
            String message = e.getMessage();
            if (message == null && e.getLinkedException() != null) {
                message = e.getLinkedException().getMessage();
            }
            throw new ModelException(message, e);
        }
    }

    @Override
    public Marshaller createMarshaller(String model) throws ModelException {
        if (model == null) {
            throw new NullPointerException("model");
        }
        try {
            StringBuilder packageNames = new StringBuilder();
            StringBuilder schemaLocation = new StringBuilder();
            Schemas schemas = this.getModlets().getSchemas(model);
            if (schemas != null) {
                for (Schema schema : schemas.getSchema()) {
                    if (schema.getContextId() != null) {
                        packageNames.append(':').append(schema.getContextId());
                    }
                    if (schema.getPublicId() == null || schema.getSystemId() == null) continue;
                    schemaLocation.append(' ').append(schema.getPublicId()).append(' ').append(schema.getSystemId());
                }
            }
            if (packageNames.length() == 0) {
                throw new ModelException(DefaultModelContext.getMessage("missingSchemas", model));
            }
            Marshaller m = JAXBContext.newInstance((String)packageNames.toString().substring(1), (ClassLoader)this.getClassLoader()).createMarshaller();
            if (schemaLocation.length() != 0) {
                m.setProperty("jaxb.schemaLocation", (Object)schemaLocation.toString().substring(1));
            }
            return m;
        }
        catch (JAXBException e) {
            String message = e.getMessage();
            if (message == null && e.getLinkedException() != null) {
                message = e.getLinkedException().getMessage();
            }
            throw new ModelException(message, e);
        }
    }

    @Override
    public Unmarshaller createUnmarshaller(String model) throws ModelException {
        if (model == null) {
            throw new NullPointerException("model");
        }
        try {
            return this.createContext(model).createUnmarshaller();
        }
        catch (JAXBException e) {
            String message = e.getMessage();
            if (message == null && e.getLinkedException() != null) {
                message = e.getLinkedException().getMessage();
            }
            throw new ModelException(message, e);
        }
    }

    @Override
    public Model processModel(Model model) throws ModelException {
        if (model == null) {
            throw new NullPointerException("model");
        }
        try {
            List<Service> processors;
            Model processed = model;
            Services services = this.getModlets().getServices(model.getIdentifier());
            List<Service> list = processors = services != null ? services.getServices(ModelProcessor.class) : null;
            if (processors != null) {
                for (Service processor : processors) {
                    Class<?> clazz = this.findClass(processor.getClazz());
                    if (clazz == null) {
                        throw new ModelException(DefaultModelContext.getMessage("serviceNotFound", processor.getOrdinal(), processor.getIdentifier(), processor.getClazz()));
                    }
                    if (!ModelProcessor.class.isAssignableFrom(clazz)) {
                        throw new ModelException(DefaultModelContext.getMessage("illegalService", processor.getOrdinal(), processor.getIdentifier(), processor.getClazz(), ModelProcessor.class.getName()));
                    }
                    Class<ModelProcessor> modelProcessorClass = clazz.asSubclass(ModelProcessor.class);
                    ModelProcessor modelProcessor = modelProcessorClass.newInstance();
                    Model current = modelProcessor.processModel(this, processed);
                    if (current == null) continue;
                    processed = current;
                }
            }
            return processed;
        }
        catch (InstantiationException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ModelException(e.getMessage(), e);
        }
    }

    @Override
    public ModelValidationReport validateModel(Model model) throws ModelException {
        if (model == null) {
            throw new NullPointerException("model");
        }
        try {
            Services services = this.getModlets().getServices(model.getIdentifier());
            List<Service> validators = services != null ? services.getServices(ModelValidator.class) : null;
            ModelValidationReport report = new ModelValidationReport();
            if (validators != null) {
                for (Service validator : validators) {
                    Class<?> clazz = this.findClass(validator.getClazz());
                    if (clazz == null) {
                        throw new ModelException(DefaultModelContext.getMessage("serviceNotFound", validator.getOrdinal(), validator.getIdentifier(), validator.getClazz()));
                    }
                    if (!ModelValidator.class.isAssignableFrom(clazz)) {
                        throw new ModelException(DefaultModelContext.getMessage("illegalService", validator.getOrdinal(), validator.getIdentifier(), validator.getClazz(), ModelValidator.class.getName()));
                    }
                    Class<ModelValidator> modelValidatorClass = clazz.asSubclass(ModelValidator.class);
                    ModelValidator modelValidator = modelValidatorClass.newInstance();
                    ModelValidationReport current = modelValidator.validateModel(this, model);
                    if (current == null) continue;
                    report.getDetails().addAll(current.getDetails());
                }
            }
            return report;
        }
        catch (InstantiationException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ModelException(e.getMessage(), e);
        }
    }

    @Override
    public ModelValidationReport validateModel(String model, Source source) throws ModelException {
        if (model == null) {
            throw new NullPointerException("model");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        javax.xml.validation.Schema schema = this.createSchema(model);
        Validator validator = schema.newValidator();
        ModelErrorHandler modelErrorHandler = new ModelErrorHandler(this);
        validator.setErrorHandler(modelErrorHandler);
        try {
            validator.validate(source);
        }
        catch (SAXException e) {
            String message = e.getMessage();
            if (message == null && e.getException() != null) {
                message = e.getException().getMessage();
            }
            if (this.isLoggable(Level.FINE)) {
                this.log(Level.FINE, message, e);
            }
            if (modelErrorHandler.getReport().isModelValid()) {
                throw new ModelException(message, e);
            }
        }
        catch (IOException e) {
            throw new ModelException(e.getMessage(), e);
        }
        return modelErrorHandler.getReport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Collection<Class<? extends T>> loadProviders(Class<T> providerClass) throws ModelException {
        try {
            String providerNamePrefix = providerClass.getName() + ".";
            TreeMap<String, Class<T>> providers = new TreeMap<String, Class<T>>(new Comparator<String>(){

                @Override
                public int compare(String key1, String key2) {
                    return key1.compareTo(key2);
                }
            });
            File platformProviders = new File(this.getPlatformProviderLocation());
            if (platformProviders.exists()) {
                if (this.isLoggable(Level.FINE)) {
                    this.log(Level.FINE, DefaultModelContext.getMessage("processing", this.getClass().getName(), platformProviders.getAbsolutePath()), null);
                }
                FileInputStream in = null;
                Properties p = new Properties();
                try {
                    in = new FileInputStream(platformProviders);
                    p.load(in);
                }
                finally {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                for (Map.Entry<Object, Object> e : p.entrySet()) {
                    if (!e.getKey().toString().startsWith(providerNamePrefix)) continue;
                    Class<?> provider = this.findClass(e.getValue().toString());
                    if (provider == null) {
                        throw new ModelException(DefaultModelContext.getMessage("implementationNotFound", providerClass.getName(), e.getValue().toString(), platformProviders.getAbsolutePath()));
                    }
                    if (!providerClass.isAssignableFrom(provider)) {
                        throw new ModelException(DefaultModelContext.getMessage("illegalImplementation", providerClass.getName(), e.getValue().toString(), platformProviders.getAbsolutePath()));
                    }
                    if (this.isLoggable(Level.FINE)) {
                        this.log(Level.FINE, DefaultModelContext.getMessage("providerInfo", this.getClass().getName(), platformProviders.getAbsolutePath(), providerClass.getName(), provider.getName()), null);
                    }
                    providers.put(e.getKey().toString(), provider.asSubclass(providerClass));
                }
            }
            Enumeration<URL> classpathProviders = this.findResources(this.getProviderLocation() + '/' + providerClass.getName());
            int count = 0;
            long t0 = System.currentTimeMillis();
            while (classpathProviders.hasMoreElements()) {
                ++count;
                URL url = classpathProviders.nextElement();
                if (this.isLoggable(Level.FINE)) {
                    this.log(Level.FINE, DefaultModelContext.getMessage("processing", this.getClass().getName(), url.toExternalForm()), null);
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (line.contains("#")) continue;
                    Class<?> provider = this.findClass(line);
                    if (provider == null) {
                        throw new ModelException(DefaultModelContext.getMessage("implementationNotFound", providerClass.getName(), line, url.toExternalForm()));
                    }
                    if (!providerClass.isAssignableFrom(provider)) {
                        throw new ModelException(DefaultModelContext.getMessage("illegalImplementation", providerClass.getName(), line, url.toExternalForm()));
                    }
                    if (this.isLoggable(Level.FINE)) {
                        this.log(Level.FINE, DefaultModelContext.getMessage("providerInfo", this.getClass().getName(), url.toExternalForm(), providerClass.getName(), provider.getName()), null);
                    }
                    providers.put(providerNamePrefix + providers.size(), provider.asSubclass(providerClass));
                }
                reader.close();
            }
            if (this.isLoggable(Level.CONFIG)) {
                this.log(Level.CONFIG, DefaultModelContext.getMessage("contextReport", this.getClass().getName(), count, this.getProviderLocation() + '/' + providerClass.getName(), System.currentTimeMillis() - t0), null);
            }
            return providers.values();
        }
        catch (IOException e) {
            throw new ModelException(e.getMessage(), e);
        }
    }

    private Set<URI> getSchemaResources() throws IOException, URISyntaxException {
        Set<URI> resources = this.cachedSchemaResources.get();
        if (resources == null) {
            resources = new HashSet<URI>();
            long t0 = System.currentTimeMillis();
            int count = 0;
            Enumeration<URL> e = this.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (e.hasMoreElements()) {
                ++count;
                URL manifestUrl = e.nextElement();
                String externalForm = manifestUrl.toExternalForm();
                String baseUrl = externalForm.substring(0, externalForm.indexOf("META-INF"));
                InputStream manifestStream = manifestUrl.openStream();
                Manifest mf = new Manifest(manifestStream);
                manifestStream.close();
                if (this.isLoggable(Level.FINE)) {
                    this.log(Level.FINE, DefaultModelContext.getMessage("processing", this.getClass().getName(), externalForm), null);
                }
                for (Map.Entry<String, Attributes> entry : mf.getEntries().entrySet()) {
                    for (int i = SCHEMA_EXTENSIONS.length - 1; i >= 0; --i) {
                        if (!entry.getKey().toLowerCase().endsWith('.' + SCHEMA_EXTENSIONS[i].toLowerCase())) continue;
                        URL schemaUrl = new URL(baseUrl + entry.getKey());
                        resources.add(schemaUrl.toURI());
                        if (!this.isLoggable(Level.CONFIG)) continue;
                        this.log(Level.CONFIG, DefaultModelContext.getMessage("foundSchemaCandidate", this.getClass().getName(), schemaUrl.toExternalForm()), null);
                    }
                }
            }
            if (this.isLoggable(Level.CONFIG)) {
                this.log(Level.CONFIG, DefaultModelContext.getMessage("contextReport", this.getClass().getName(), count, "META-INF/MANIFEST.MF", System.currentTimeMillis() - t0), null);
            }
            this.cachedSchemaResources = new SoftReference<Set<URI>>(resources);
        }
        return resources;
    }

    private static String getMessage(String key, Object ... arguments) {
        return MessageFormat.format(ResourceBundle.getBundle(DefaultModelContext.class.getName().replace('.', '/')).getString(key), arguments);
    }
}

