/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.spring.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jolokia.jvmagent.spring.SpringJolokiaConfigHolder;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

class ConfigBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String[] SKIP_ATTRIBUTES = new String[]{"order", "xmlns", "xmlns:xsi", "xsi:schemaLocation", "id"};
    private Set<String> skipMap = new HashSet<String>(Arrays.asList(SKIP_ATTRIBUTES));

    ConfigBeanDefinitionParser() {
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        HashMap config = new HashMap();
        builder.addPropertyValue("config", this.createConfigMap(element.getAttributes()));
        String order = element.getAttribute("order");
        if (StringUtils.hasText((String)order)) {
            builder.addPropertyValue("order", (Object)Integer.parseInt(order));
        }
    }

    private Map<Object, Object> createConfigMap(NamedNodeMap attributes) {
        ManagedMap map = new ManagedMap(attributes.getLength());
        map.setKeyTypeName("java.lang.String");
        map.setValueTypeName("java.lang.String");
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            String name = attr.getName();
            if (this.skipMap.contains(name)) continue;
            TypedStringValue key = new TypedStringValue(name, String.class);
            TypedStringValue value = new TypedStringValue(attr.getValue(), String.class);
            map.put((Object)key, (Object)value);
        }
        return map;
    }

    protected Class<?> getBeanClass(Element element) {
        return SpringJolokiaConfigHolder.class;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }
}

