/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.rewrite;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import org.joinfaces.autoconfigure.rewrite.ApplicationContextProvider;
import org.ocpsoft.common.spi.ServiceEnricher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class SpringBootServiceEnricher
implements ServiceEnricher {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringBootServiceEnricher.class);

    public <T> Collection<T> produce(Class<T> type) {
        ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
        if (applicationContext == null) {
            log.info("No application context found. Can't produce services of type {}", type);
            return new ArrayList();
        }
        return applicationContext.getBeanProvider(type).orderedStream().collect(Collectors.toList());
    }

    public <T> void enrich(T service) {
        ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
        if (applicationContext != null) {
            applicationContext.getAutowireCapableBeanFactory().autowireBean(service);
        }
    }
}

