/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jodd.http.Buffer;
import jodd.http.Cookie;
import jodd.http.HeadersMultiMap;
import jodd.http.HttpException;
import jodd.http.HttpMultiMap;
import jodd.http.HttpProgressListener;
import jodd.http.HttpUtil;
import jodd.http.upload.ByteArrayUploadable;
import jodd.http.upload.FileUpload;
import jodd.http.upload.FileUploadable;
import jodd.http.upload.MultipartStreamParser;
import jodd.http.upload.Uploadable;
import jodd.io.FileNameUtil;
import jodd.io.IOUtil;
import jodd.net.MimeTypes;
import jodd.time.TimeUtil;
import jodd.util.RandomString;
import jodd.util.StringUtil;

public abstract class HttpBase<T> {
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_HOST = "Host";
    public static final String HEADER_ETAG = "ETag";
    public static final String HEADER_CONNECTION = "Connection";
    public static final String HEADER_KEEP_ALIVE = "Keep-Alive";
    public static final String HEADER_CLOSE = "Close";
    public static final String HTTP_1_0 = "HTTP/1.0";
    public static final String HTTP_1_1 = "HTTP/1.1";
    protected String httpVersion = "HTTP/1.1";
    protected boolean capitalizeHeaderKeys = Defaults.capitalizeHeaderKeys;
    protected final HeadersMultiMap headers = new HeadersMultiMap();
    protected HttpMultiMap<?> form;
    protected String body;
    protected String charset;
    protected String mediaType;
    protected String formEncoding = Defaults.formEncoding;
    protected boolean multipart = false;
    protected HttpProgressListener httpProgressListener;

    protected T _this() {
        return (T)this;
    }

    public String httpVersion() {
        return this.httpVersion;
    }

    public T httpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
        return this._this();
    }

    public boolean capitalizeHeaderKeys() {
        return this.capitalizeHeaderKeys;
    }

    public T capitalizeHeaderKeys(boolean capitalizeHeaderKeys) {
        this.capitalizeHeaderKeys = capitalizeHeaderKeys;
        return this._this();
    }

    public String header(String name) {
        return this.headers.getHeader(name);
    }

    public List<String> headers(String name) {
        return this.headers.getAll(name);
    }

    public void headerRemove(String name) {
        this.headers.remove(name.trim());
    }

    public T header(String name, String value) {
        return this._header(name, value, false);
    }

    public T header(Map<String, String> headerMap) {
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            this.header(entry.getKey(), entry.getValue());
        }
        return this._this();
    }

    public T headerOverwrite(String name, String value) {
        return this._header(name, value, true);
    }

    protected T _header(String name, String value, boolean overwrite) {
        String key = name.trim();
        if (key.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
            value = value.trim();
            this.mediaType = HttpUtil.extractMediaType(value);
            this.charset = HttpUtil.extractContentTypeCharset(value);
        }
        this._headerRaw(name, value, overwrite);
        return this._this();
    }

    protected void _headerRaw(String name, String value, boolean overwrite) {
        name = name.trim();
        value = value.trim();
        if (overwrite) {
            this.headers.setHeader(name, value);
        } else {
            this.headers.addHeader(name, value);
        }
    }

    public T header(String name, int value) {
        this._headerRaw(name, String.valueOf(value), false);
        return this._this();
    }

    public T header(String name, long millis) {
        this._headerRaw(name, TimeUtil.formatHttpDate((long)millis), false);
        return this._this();
    }

    public Collection<String> headerNames() {
        return this.headers.names();
    }

    public String tokenAuthentication() {
        String value = (String)this.headers.get(HEADER_AUTHORIZATION);
        if (value == null) {
            return null;
        }
        int ndx = value.indexOf("Bearer ");
        if (ndx == -1) {
            return null;
        }
        return value.substring(ndx + 7).trim();
    }

    public String charset() {
        return this.charset;
    }

    public T charset(String charset) {
        this.charset = null;
        this.contentType(null, charset);
        return this._this();
    }

    public String mediaType() {
        return this.mediaType;
    }

    public T mediaType(String mediaType) {
        this.contentType(mediaType, null);
        return this._this();
    }

    public String contentType() {
        return this.header(HEADER_CONTENT_TYPE);
    }

    public T contentType(String contentType) {
        this.headerOverwrite(HEADER_CONTENT_TYPE, contentType);
        return this._this();
    }

    public T contentType(String mediaType, String charset) {
        if (mediaType == null) {
            mediaType = this.mediaType;
        } else {
            this.mediaType = mediaType;
        }
        if (charset == null) {
            charset = this.charset;
        } else {
            this.charset = charset;
        }
        String contentType = mediaType;
        if (charset != null) {
            contentType = contentType + ";charset=" + charset;
        }
        this._headerRaw(HEADER_CONTENT_TYPE, contentType, true);
        return this._this();
    }

    public T connectionKeepAlive(boolean keepAlive) {
        if (keepAlive) {
            this.headerOverwrite(HEADER_CONNECTION, HEADER_KEEP_ALIVE);
        } else {
            this.headerOverwrite(HEADER_CONNECTION, HEADER_CLOSE);
        }
        return this._this();
    }

    public boolean isConnectionPersistent() {
        String connection = this.header(HEADER_CONNECTION);
        if (connection == null) {
            return !this.httpVersion.equalsIgnoreCase(HTTP_1_0);
        }
        return !connection.equalsIgnoreCase(HEADER_CLOSE);
    }

    public String contentLength() {
        return this.header(HEADER_CONTENT_LENGTH);
    }

    public T contentLength(int value) {
        this._headerRaw(HEADER_CONTENT_LENGTH, String.valueOf(value), true);
        return this._this();
    }

    public String contentEncoding() {
        return this.header(HEADER_CONTENT_ENCODING);
    }

    public String accept() {
        return this.header(HEADER_ACCEPT);
    }

    public T accept(String encodings) {
        this.headerOverwrite(HEADER_ACCEPT, encodings);
        return this._this();
    }

    public String acceptEncoding() {
        return this.header(HEADER_ACCEPT_ENCODING);
    }

    public T acceptEncoding(String encodings) {
        this.headerOverwrite(HEADER_ACCEPT_ENCODING, encodings);
        return this._this();
    }

    protected void initForm() {
        if (this.form == null) {
            this.form = HttpMultiMap.newCaseInsensitiveMap();
        }
    }

    protected Object wrapFormValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof File) {
            return new FileUploadable((File)value);
        }
        if (value instanceof byte[]) {
            return new ByteArrayUploadable((byte[])value, null);
        }
        if (value instanceof Uploadable) {
            return value;
        }
        throw new HttpException("Unsupported value type: " + value.getClass().getName());
    }

    public T form(String name, Object value) {
        this.initForm();
        value = this.wrapFormValue(value);
        this.form.add(name, value);
        return this._this();
    }

    public T formOverwrite(String name, Object value) {
        this.initForm();
        value = this.wrapFormValue(value);
        this.form.set(name, value);
        return this._this();
    }

    public T form(String name, Object value, Object ... parameters) {
        this.initForm();
        this.form(name, value);
        for (int i = 0; i < parameters.length; i += 2) {
            name = parameters[i].toString();
            this.form(name, parameters[i + 1]);
        }
        return this._this();
    }

    public T form(Map<String, Object> formMap) {
        this.initForm();
        for (Map.Entry<String, Object> entry : formMap.entrySet()) {
            this.form(entry.getKey(), entry.getValue());
        }
        return this._this();
    }

    public HttpMultiMap<?> form() {
        return this.form;
    }

    public T formEncoding(String encoding) {
        this.formEncoding = encoding;
        return this._this();
    }

    public Cookie[] cookies() {
        String cookieHeader = this.header("cookie");
        if (!StringUtil.isNotBlank((CharSequence)cookieHeader)) {
            return new Cookie[0];
        }
        return (Cookie[])Arrays.stream(StringUtil.splitc((String)cookieHeader, (char)';')).map(Cookie::new).toArray(Cookie[]::new);
    }

    public String bodyRaw() {
        return this.body;
    }

    public byte[] bodyBytes() {
        if (this.body == null) {
            return null;
        }
        return this.body.getBytes(StandardCharsets.ISO_8859_1);
    }

    public String bodyText() {
        if (this.body == null) {
            return "";
        }
        if (this.charset != null) {
            return StringUtil.convertCharset((String)this.body, (Charset)StandardCharsets.ISO_8859_1, (Charset)Charset.forName(this.charset));
        }
        return this.bodyRaw();
    }

    public T body(String body) {
        this.body = body;
        this.form = null;
        this.contentLength(body.length());
        return this._this();
    }

    public T bodyText(String body, String mediaType, String charset) {
        body = StringUtil.convertCharset((String)body, (Charset)Charset.forName(charset), (Charset)StandardCharsets.ISO_8859_1);
        this.contentType(mediaType, charset);
        this.body(body);
        return this._this();
    }

    public T bodyText(String body, String mediaType) {
        return this.bodyText(body, mediaType, this.charset != null ? this.charset : Defaults.bodyEncoding);
    }

    public T bodyText(String body) {
        return this.bodyText(body, this.mediaType != null ? this.mediaType : Defaults.bodyMediaType, this.charset != null ? this.charset : Defaults.bodyEncoding);
    }

    public T body(byte[] content, String contentType) {
        String body = null;
        try {
            body = new String(content, StandardCharsets.ISO_8859_1.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.contentType(contentType);
        return this.body(body);
    }

    protected boolean isFormMultipart() {
        if (this.multipart) {
            return true;
        }
        for (Map.Entry<String, ?> entry : this.form) {
            Object value = entry.getValue();
            if (!(value instanceof Uploadable)) continue;
            return true;
        }
        return false;
    }

    protected Buffer formBuffer() {
        Buffer buffer = new Buffer();
        if (this.form == null || this.form.isEmpty()) {
            return buffer;
        }
        if (!this.isFormMultipart()) {
            String formEncoding = this.resolveFormEncoding();
            String formQueryString = HttpUtil.buildQuery(this.form, formEncoding);
            this.contentType("application/x-www-form-urlencoded", null);
            this.contentLength(formQueryString.length());
            buffer.append(formQueryString);
            return buffer;
        }
        String boundary = StringUtil.repeat((char)'-', (int)10) + RandomString.get().randomAlphaNumeric(10);
        for (Map.Entry<String, ?> entry : this.form) {
            buffer.append("--");
            buffer.append(boundary);
            buffer.append("\r\n");
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                String string = (String)value;
                buffer.append("Content-Disposition: form-data; name=\"").append(name).append('\"').append("\r\n");
                buffer.append("\r\n");
                String formEncoding = this.resolveFormEncoding();
                String utf8String = StringUtil.convertCharset((String)string, (Charset)Charset.forName(formEncoding), (Charset)StandardCharsets.ISO_8859_1);
                buffer.append(utf8String);
            } else if (value instanceof Uploadable) {
                Uploadable uploadable = (Uploadable)value;
                String fileName = uploadable.getFileName();
                if (fileName == null) {
                    fileName = name;
                } else {
                    String formEncoding = this.resolveFormEncoding();
                    fileName = StringUtil.convertCharset((String)fileName, (Charset)Charset.forName(formEncoding), (Charset)StandardCharsets.ISO_8859_1);
                }
                buffer.append("Content-Disposition: form-data; name=\"").append(name);
                buffer.append("\"; filename=\"").append(fileName).append('\"').append("\r\n");
                String mimeType = uploadable.getMimeType();
                if (mimeType == null) {
                    mimeType = MimeTypes.getMimeType((String)FileNameUtil.getExtension((String)fileName));
                }
                buffer.append(HEADER_CONTENT_TYPE).append(": ").append(mimeType).append("\r\n");
                buffer.append("Content-Transfer-Encoding: binary").append("\r\n");
                buffer.append("\r\n");
                buffer.append(uploadable);
            } else {
                throw new HttpException("Unsupported type");
            }
            buffer.append("\r\n");
        }
        buffer.append("--").append(boundary).append("--");
        buffer.append("\r\n");
        this.contentType("multipart/form-data; boundary=" + boundary);
        this.contentLength(buffer.size());
        return buffer;
    }

    protected String resolveFormEncoding() {
        String formEncoding = this.charset;
        if (formEncoding == null) {
            formEncoding = this.formEncoding;
        }
        return formEncoding;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean fullResponse) {
        Buffer buffer = this.buffer(fullResponse);
        StringWriter stringWriter = new StringWriter();
        try {
            buffer.writeTo(stringWriter);
        }
        catch (IOException ioex) {
            throw new HttpException(ioex);
        }
        return stringWriter.toString();
    }

    public byte[] toByteArray() {
        Buffer buffer = this.buffer(true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(buffer.size());
        try {
            buffer.writeTo(baos);
        }
        catch (IOException ioex) {
            throw new HttpException(ioex);
        }
        return baos.toByteArray();
    }

    protected abstract Buffer buffer(boolean var1);

    protected void populateHeaderAndBody(Buffer target, Buffer formBuffer, boolean fullRequest) {
        for (String name : this.headers.names()) {
            List values = this.headers.getAll(name);
            String key = this.capitalizeHeaderKeys ? HttpUtil.prepareHeaderParameterName(name) : name;
            target.append(key);
            target.append(": ");
            int count = 0;
            for (String value : values) {
                if (count++ > 0) {
                    target.append(", ");
                }
                target.append(value);
            }
            target.append("\r\n");
        }
        if (fullRequest) {
            target.append("\r\n");
            if (this.form != null) {
                target.append(formBuffer);
            } else if (this.body != null) {
                target.append(this.body);
            }
        }
    }

    public void sendTo(OutputStream out) throws IOException {
        Buffer buffer = this.buffer(true);
        if (this.httpProgressListener == null) {
            buffer.writeTo(out);
        } else {
            buffer.writeTo(out, this.httpProgressListener);
        }
        out.flush();
    }

    protected void readHeaders(BufferedReader reader) {
        block3: {
            String line;
            while (true) {
                try {
                    line = reader.readLine();
                }
                catch (IOException ioex) {
                    throw new HttpException(ioex);
                }
                if (StringUtil.isBlank((CharSequence)line)) break block3;
                int ndx = line.indexOf(58);
                if (ndx == -1) break;
                this.header(line.substring(0, ndx), line.substring(ndx + 1));
            }
            throw new HttpException("Invalid header: " + line);
        }
    }

    protected void readBody(BufferedReader reader) {
        String charset;
        CharArrayWriter fastCharArrayWriter;
        String bodyString = null;
        boolean isChunked = false;
        String transferEncoding = this.header("Transfer-Encoding");
        if (transferEncoding != null && transferEncoding.equalsIgnoreCase("chunked")) {
            isChunked = true;
        }
        String contentLen = this.contentLength();
        int contentLenValue = -1;
        if (contentLen != null && !isChunked && (contentLenValue = Integer.parseInt(contentLen)) > 0) {
            fastCharArrayWriter = new CharArrayWriter(contentLenValue);
            try {
                IOUtil.copy((Reader)reader, (Writer)fastCharArrayWriter, (int)contentLenValue);
            }
            catch (IOException ioex) {
                throw new HttpException(ioex);
            }
            bodyString = fastCharArrayWriter.toString();
        }
        if (isChunked) {
            fastCharArrayWriter = new CharArrayWriter();
            try {
                while (true) {
                    int len;
                    String line;
                    if ((line = reader.readLine()) != null) {
                        try {
                            len = Integer.parseInt(line, 16);
                        }
                        catch (NumberFormatException nfex) {
                            throw new HttpException("Invalid chunk length: " + line);
                        }
                    } else {
                        len = 0;
                    }
                    if (len <= 0) break;
                    IOUtil.copy((Reader)reader, (Writer)fastCharArrayWriter, (int)len);
                    reader.readLine();
                }
                this.readHeaders(reader);
            }
            catch (IOException ioex) {
                throw new HttpException(ioex);
            }
            bodyString = fastCharArrayWriter.toString();
        }
        if (bodyString == null && contentLenValue != 0) {
            fastCharArrayWriter = new CharArrayWriter();
            try {
                IOUtil.copy((Reader)reader, (Writer)fastCharArrayWriter);
            }
            catch (IOException ioex) {
                throw new HttpException(ioex);
            }
            bodyString = fastCharArrayWriter.toString();
        }
        if ((charset = this.charset) == null) {
            charset = StandardCharsets.ISO_8859_1.name();
        }
        this.body = bodyString;
        String mediaType = this.mediaType();
        mediaType = mediaType == null ? "" : mediaType.toLowerCase();
        if (mediaType.equals("application/x-www-form-urlencoded")) {
            this.form = HttpUtil.parseQuery(bodyString, true);
            return;
        }
        if (mediaType.equals("multipart/form-data")) {
            this.form = HttpMultiMap.newCaseInsensitiveMap();
            MultipartStreamParser multipartParser = new MultipartStreamParser();
            try {
                byte[] bodyBytes = bodyString.getBytes(StandardCharsets.ISO_8859_1.name());
                ByteArrayInputStream bin = new ByteArrayInputStream(bodyBytes);
                multipartParser.parseRequestStream(bin, charset);
            }
            catch (IOException ioex) {
                throw new HttpException(ioex);
            }
            for (String paramName : multipartParser.getParameterNames()) {
                String[] values = multipartParser.getParameterValues(paramName);
                for (String value : values) {
                    this.form.add(paramName, value);
                }
            }
            for (String paramName : multipartParser.getFileParameterNames()) {
                FileUpload[] uploads = multipartParser.getFiles(paramName);
                for (FileUpload upload : uploads) {
                    this.form.add(paramName, upload);
                }
            }
            return;
        }
        this.form = null;
    }

    public static class Defaults {
        public static final int DEFAULT_PORT = -1;
        public static String queryEncoding = "UTF-8";
        public static String formEncoding = "UTF-8";
        public static String bodyMediaType = "text/html";
        public static String bodyEncoding = "UTF-8";
        public static String userAgent = "Jodd HTTP";
        public static boolean capitalizeHeaderKeys = true;
    }
}

