/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.cassandra.converters;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import org.jnosql.artemis.AttributeConverter;

public class LocalDateConverter
implements AttributeConverter<Object, com.datastax.driver.core.LocalDate> {
    private static final ZoneId ZONE_ID = ZoneId.systemDefault();

    public com.datastax.driver.core.LocalDate convertToDatabaseColumn(Object attribute) {
        if (com.datastax.driver.core.LocalDate.class.isInstance(attribute)) {
            return (com.datastax.driver.core.LocalDate)com.datastax.driver.core.LocalDate.class.cast(attribute);
        }
        if (attribute == null) {
            return null;
        }
        if (Number.class.isInstance(attribute)) {
            return com.datastax.driver.core.LocalDate.fromMillisSinceEpoch((long)((Number)Number.class.cast(attribute)).longValue());
        }
        if (LocalDate.class.isInstance(attribute)) {
            Date date = Date.from(((LocalDate)LocalDate.class.cast(attribute)).atStartOfDay(ZONE_ID).toInstant());
            return com.datastax.driver.core.LocalDate.fromMillisSinceEpoch((long)date.getTime());
        }
        if (LocalDateTime.class.isInstance(attribute)) {
            Date date = Date.from(((LocalDateTime)LocalDateTime.class.cast(attribute)).atZone(ZONE_ID).toInstant());
            return com.datastax.driver.core.LocalDate.fromMillisSinceEpoch((long)date.getTime());
        }
        if (ZonedDateTime.class.isInstance(attribute)) {
            Date date = Date.from(((ZonedDateTime)ZonedDateTime.class.cast(attribute)).toInstant());
            return com.datastax.driver.core.LocalDate.fromMillisSinceEpoch((long)date.getTime());
        }
        if (Date.class.isInstance(attribute)) {
            return com.datastax.driver.core.LocalDate.fromMillisSinceEpoch((long)((Date)Date.class.cast(attribute)).getTime());
        }
        if (Calendar.class.isInstance(attribute)) {
            return com.datastax.driver.core.LocalDate.fromMillisSinceEpoch((long)((Calendar)Calendar.class.cast(attribute)).getTime().getTime());
        }
        throw new IllegalArgumentException("There is not support to: " + attribute.getClass());
    }

    public Object convertToEntityAttribute(com.datastax.driver.core.LocalDate dbData) {
        LocalDate localDate = LocalDate.of(dbData.getYear(), dbData.getMonth(), dbData.getDay());
        return Date.from(localDate.atStartOfDay(ZONE_ID).toInstant()).getTime();
    }
}

