/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.cassandra.column;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Statement;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.cassandra.column.CassandraColumnEntityConverter;
import org.jnosql.artemis.cassandra.column.CassandraTemplateAsync;
import org.jnosql.artemis.column.AbstractColumnTemplateAsync;
import org.jnosql.artemis.column.ColumnEntityConverter;
import org.jnosql.artemis.reflection.ClassMappings;
import org.jnosql.diana.api.column.ColumnDeleteQuery;
import org.jnosql.diana.api.column.ColumnEntity;
import org.jnosql.diana.api.column.ColumnFamilyManagerAsync;
import org.jnosql.diana.api.column.ColumnQuery;
import org.jnosql.diana.cassandra.column.CassandraColumnFamilyManagerAsync;

@Typed(value={CassandraTemplateAsync.class})
class DefaultCassandraTemplateAsync
extends AbstractColumnTemplateAsync
implements CassandraTemplateAsync {
    private CassandraColumnEntityConverter converter;
    private Instance<CassandraColumnFamilyManagerAsync> managerAsync;
    private ClassMappings mappings;
    private Converters converters;

    DefaultCassandraTemplateAsync() {
    }

    @Inject
    DefaultCassandraTemplateAsync(CassandraColumnEntityConverter converter, Instance<CassandraColumnFamilyManagerAsync> managerAsync, ClassMappings mappings, Converters converters) {
        this.converter = converter;
        this.managerAsync = managerAsync;
        this.mappings = mappings;
        this.converters = converters;
    }

    protected ColumnEntityConverter getConverter() {
        return this.converter;
    }

    protected ColumnFamilyManagerAsync getManager() {
        return (ColumnFamilyManagerAsync)this.managerAsync.get();
    }

    protected ClassMappings getClassMappings() {
        return this.mappings;
    }

    protected Converters getConverters() {
        return this.converters;
    }

    @Override
    public <T> void save(T entity, ConsistencyLevel level) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(level, "level is required");
        ((CassandraColumnFamilyManagerAsync)this.managerAsync.get()).save(this.converter.toColumn(entity), level);
    }

    @Override
    public <T> void save(T entity, ConsistencyLevel level, Consumer<T> callBack) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(level, "level is required");
        Objects.requireNonNull(callBack, "callBack is required");
        Consumer<ColumnEntity> dianaCallBack = c -> callBack.accept(this.getConverter().toEntity(entity.getClass(), c));
        ((CassandraColumnFamilyManagerAsync)this.managerAsync.get()).save(this.converter.toColumn(entity), level, dianaCallBack);
    }

    @Override
    public <T> void save(T entity, Duration ttl, ConsistencyLevel level) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(level, "level is required");
        Objects.requireNonNull(ttl, "ttl is required");
        ((CassandraColumnFamilyManagerAsync)this.managerAsync.get()).save(this.converter.toColumn(entity), ttl, level);
    }

    @Override
    public <T> void save(Iterable<T> entities, ConsistencyLevel level) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(level, "level is required");
        StreamSupport.stream(entities.spliterator(), false).map(arg_0 -> ((CassandraColumnEntityConverter)this.converter).toColumn(arg_0)).forEach(c -> ((CassandraColumnFamilyManagerAsync)this.managerAsync.get()).save(c, level));
    }

    @Override
    public <T> void save(Iterable<T> entities, Duration ttl, ConsistencyLevel level) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(level, "level is required");
        Objects.requireNonNull(ttl, "ttl is required");
        StreamSupport.stream(entities.spliterator(), false).map(arg_0 -> ((CassandraColumnEntityConverter)this.converter).toColumn(arg_0)).forEach(c -> ((CassandraColumnFamilyManagerAsync)this.managerAsync.get()).save(c, ttl, level));
    }

    @Override
    public <T> void save(T entity, Duration ttl, ConsistencyLevel level, Consumer<T> callBack) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(level, "level is required");
        Objects.requireNonNull(ttl, "ttl is required");
        Objects.requireNonNull(callBack, "callBack is required");
        Consumer<ColumnEntity> dianaCallBack = c -> callBack.accept(this.getConverter().toEntity(entity.getClass(), c));
        ((CassandraColumnFamilyManagerAsync)this.managerAsync.get()).save(this.converter.toColumn(entity), ttl, level, dianaCallBack);
    }

    @Override
    public <T> void delete(ColumnDeleteQuery query, ConsistencyLevel level) {
        ((CassandraColumnFamilyManagerAsync)this.managerAsync.get()).delete(query, level);
    }

    @Override
    public void delete(ColumnDeleteQuery query, ConsistencyLevel level, Consumer<Void> consumer) {
        ((CassandraColumnFamilyManagerAsync)this.managerAsync.get()).delete(query, level, consumer);
    }

    @Override
    public <T> void select(ColumnQuery query, ConsistencyLevel level, Consumer<List<T>> callBack) {
        Objects.requireNonNull(callBack, "callBack is required");
        Consumer<List> dianaCallBack = d -> callBack.accept(d.stream().map(arg_0 -> ((ColumnEntityConverter)this.getConverter()).toEntity(arg_0)).map(o -> o).collect(Collectors.toList()));
        ((CassandraColumnFamilyManagerAsync)this.managerAsync.get()).select(query, level, dianaCallBack);
    }

    @Override
    public <T> void cql(String query, Consumer<List<T>> callBack) {
        Objects.requireNonNull(callBack, "callBack is required");
        Consumer<List> dianaCallBack = d -> callBack.accept(d.stream().map(arg_0 -> ((ColumnEntityConverter)this.getConverter()).toEntity(arg_0)).map(o -> o).collect(Collectors.toList()));
        ((CassandraColumnFamilyManagerAsync)this.managerAsync.get()).cql(query, dianaCallBack);
    }

    @Override
    public <T> void cql(String query, Map<String, Object> values, Consumer<List<T>> callBack) {
        Objects.requireNonNull(callBack, "callBack is required");
        Consumer<List> dianaCallBack = d -> callBack.accept(d.stream().map(arg_0 -> ((ColumnEntityConverter)this.getConverter()).toEntity(arg_0)).map(o -> o).collect(Collectors.toList()));
        ((CassandraColumnFamilyManagerAsync)this.managerAsync.get()).cql(query, values, dianaCallBack);
    }

    @Override
    public <T> void cql(String query, Consumer<List<T>> callBack, Object ... params) {
        Objects.requireNonNull(query, "callBack is required");
        Objects.requireNonNull(callBack, "callBack is required");
        Objects.requireNonNull(params, "params is required");
        Consumer<List> dianaCallBack = d -> callBack.accept(d.stream().map(arg_0 -> ((ColumnEntityConverter)this.getConverter()).toEntity(arg_0)).map(o -> o).collect(Collectors.toList()));
        ((CassandraColumnFamilyManagerAsync)this.managerAsync.get()).nativeQueryPrepare(query).bind(params).executeQueryAsync(dianaCallBack);
    }

    @Override
    public <T> void execute(Statement statement, Consumer<List<T>> callBack) {
        Objects.requireNonNull(callBack, "callBack is required");
        Consumer<List> dianaCallBack = d -> callBack.accept(d.stream().map(arg_0 -> ((ColumnEntityConverter)this.getConverter()).toEntity(arg_0)).map(o -> o).collect(Collectors.toList()));
        ((CassandraColumnFamilyManagerAsync)this.managerAsync.get()).execute(statement, dianaCallBack);
    }
}

