/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.cassandra.column;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Statement;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.cassandra.column.CassandraColumnEntityConverter;
import org.jnosql.artemis.cassandra.column.CassandraColumnWorkflow;
import org.jnosql.artemis.cassandra.column.CassandraTemplate;
import org.jnosql.artemis.column.AbstractColumnTemplate;
import org.jnosql.artemis.column.ColumnEntityConverter;
import org.jnosql.artemis.column.ColumnEventPersistManager;
import org.jnosql.artemis.column.ColumnWorkflow;
import org.jnosql.artemis.reflection.ClassMappings;
import org.jnosql.diana.api.column.ColumnDeleteQuery;
import org.jnosql.diana.api.column.ColumnEntity;
import org.jnosql.diana.api.column.ColumnFamilyManager;
import org.jnosql.diana.api.column.ColumnQuery;
import org.jnosql.diana.cassandra.column.CassandraColumnFamilyManager;
import org.jnosql.diana.cassandra.column.CassandraPrepareStatment;

@Typed(value={CassandraTemplate.class})
class DefaultCassandraTemplate
extends AbstractColumnTemplate
implements CassandraTemplate {
    private Instance<CassandraColumnFamilyManager> manager;
    private CassandraColumnEntityConverter converter;
    private CassandraColumnWorkflow flow;
    private ColumnEventPersistManager persistManager;
    private ClassMappings mappings;
    private Converters converters;

    @Inject
    DefaultCassandraTemplate(Instance<CassandraColumnFamilyManager> manager, CassandraColumnEntityConverter converter, CassandraColumnWorkflow flow, ColumnEventPersistManager persistManager, ClassMappings mappings, Converters converters) {
        this.manager = manager;
        this.converter = converter;
        this.flow = flow;
        this.persistManager = persistManager;
        this.mappings = mappings;
        this.converters = converters;
    }

    DefaultCassandraTemplate() {
    }

    protected ColumnEntityConverter getConverter() {
        return this.converter;
    }

    protected ColumnFamilyManager getManager() {
        return (ColumnFamilyManager)this.manager.get();
    }

    protected ColumnWorkflow getFlow() {
        return this.flow;
    }

    protected ColumnEventPersistManager getEventManager() {
        return this.persistManager;
    }

    protected ClassMappings getClassMappings() {
        return this.mappings;
    }

    protected Converters getConverters() {
        return this.converters;
    }

    @Override
    public <T> T save(T entity, ConsistencyLevel level) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(level, "level is required");
        UnaryOperator save = e -> ((CassandraColumnFamilyManager)this.manager.get()).save(e, level);
        return (T)this.getFlow().flow(entity, save);
    }

    @Override
    public <T> Iterable<T> save(Iterable<T> entities, Duration ttl, ConsistencyLevel level) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(ttl, "ttl is required");
        Objects.requireNonNull(level, "level is required");
        return StreamSupport.stream(entities.spliterator(), false).map(arg_0 -> ((CassandraColumnEntityConverter)this.converter).toColumn(arg_0)).map(e -> ((CassandraColumnFamilyManager)this.manager.get()).save(e, ttl, level)).map(arg_0 -> ((CassandraColumnEntityConverter)this.converter).toEntity(arg_0)).map(e -> e).collect(Collectors.toList());
    }

    @Override
    public <T> Iterable<T> save(Iterable<T> entities, ConsistencyLevel level) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(level, "level is required");
        return StreamSupport.stream(entities.spliterator(), false).map(arg_0 -> ((CassandraColumnEntityConverter)this.converter).toColumn(arg_0)).map(e -> ((CassandraColumnFamilyManager)this.manager.get()).save(e, level)).map(arg_0 -> ((CassandraColumnEntityConverter)this.converter).toEntity(arg_0)).map(e -> e).collect(Collectors.toList());
    }

    @Override
    public <T> T save(T entity, Duration ttl, ConsistencyLevel level) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(ttl, "ttl is required");
        Objects.requireNonNull(level, "level is required");
        UnaryOperator save = e -> ((CassandraColumnFamilyManager)this.manager.get()).save(e, ttl, level);
        return (T)this.getFlow().flow(entity, save);
    }

    @Override
    public void delete(ColumnDeleteQuery query, ConsistencyLevel level) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(level, "level is required");
        this.persistManager.firePreDeleteQuery(query);
        ((CassandraColumnFamilyManager)this.manager.get()).delete(query, level);
    }

    @Override
    public <T> List<T> find(ColumnQuery query, ConsistencyLevel level) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(level, "level is required");
        this.persistManager.firePreQuery(query);
        return ((CassandraColumnFamilyManager)this.manager.get()).select(query, level).stream().map(c -> this.converter.toEntity((ColumnEntity)c)).collect(Collectors.toList());
    }

    @Override
    public <T> List<T> cql(String query) {
        return ((CassandraColumnFamilyManager)this.manager.get()).cql(query).stream().map(c -> this.converter.toEntity((ColumnEntity)c)).collect(Collectors.toList());
    }

    @Override
    public <T> List<T> cql(String query, Map<String, Object> values) {
        return ((CassandraColumnFamilyManager)this.manager.get()).cql(query, values).stream().map(c -> this.converter.toEntity((ColumnEntity)c)).collect(Collectors.toList());
    }

    @Override
    public <T> List<T> cql(String query, Object ... params) {
        Objects.requireNonNull(query, "query is required");
        CassandraPrepareStatment cassandraPrepareStatment = ((CassandraColumnFamilyManager)this.manager.get()).nativeQueryPrepare(query);
        List entities = cassandraPrepareStatment.bind(params).executeQuery();
        return entities.stream().map(arg_0 -> ((CassandraColumnEntityConverter)this.converter).toEntity(arg_0)).map(e -> e).collect(Collectors.toList());
    }

    @Override
    public <T> List<T> execute(Statement statement) {
        return ((CassandraColumnFamilyManager)this.manager.get()).execute(statement).stream().map(c -> this.converter.toEntity((ColumnEntity)c)).collect(Collectors.toList());
    }
}

