/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.cassandra.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.column.ColumnEntityConverter;
import org.jnosql.artemis.column.ColumnFieldValue;
import org.jnosql.artemis.reflection.FieldMapping;
import org.jnosql.diana.api.column.Column;
import org.jnosql.diana.cassandra.column.UDT;

class CassandraUDTType
implements ColumnFieldValue {
    private final String type;
    private final Object value;
    private final FieldMapping field;

    CassandraUDTType(String type, Object value, FieldMapping field) {
        this.value = value;
        this.type = type;
        this.field = Objects.requireNonNull(field, "field is required");
    }

    public Object getValue() {
        return this.value;
    }

    public FieldMapping getField() {
        return this.field;
    }

    public boolean isNotEmpty() {
        return this.value != null;
    }

    public List<Column> toColumn(ColumnEntityConverter converter, Converters converters) {
        if (Iterable.class.isInstance(this.value)) {
            ArrayList columns = new ArrayList();
            StreamSupport.stream(((Iterable)Iterable.class.cast(this.value)).spliterator(), false).forEach(c -> columns.add(converter.toColumn(c).getColumns()));
            return Collections.singletonList(UDT.builder((String)this.type).withName(this.field.getName()).addUDTs(columns).build());
        }
        return Collections.singletonList(UDT.builder((String)this.type).withName(this.field.getName()).addUDT((Iterable)converter.toColumn(this.value).getColumns()).build());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CassandraUDTType{");
        sb.append("type='").append(this.type).append('\'');
        sb.append(", value=").append(this.value);
        sb.append(", field=").append(this.field);
        sb.append('}');
        return sb.toString();
    }
}

