/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.cassandra.column;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.cassandra.column.CQL;
import org.jnosql.artemis.cassandra.column.CQLObjectUtil;
import org.jnosql.artemis.cassandra.column.CassandraTemplate;
import org.jnosql.artemis.reflection.DynamicReturn;

class CassandraRepositoryProxy<T>
implements InvocationHandler {
    private final Class<T> typeClass;
    private final CassandraTemplate template;
    private final Repository<T, ?> repository;

    CassandraRepositoryProxy(CassandraTemplate template, Class<?> repositoryType, Repository<T, ?> repository) {
        this.template = template;
        this.typeClass = (Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(repositoryType.getGenericInterfaces()[0])).getActualTypeArguments()[0]);
        this.repository = repository;
    }

    @Override
    public Object invoke(Object o, Method method, Object[] args) throws Throwable {
        CQL cql = method.getAnnotation(CQL.class);
        if (Objects.nonNull(cql)) {
            Map<String, Object> values = CQLObjectUtil.getValues(args, method);
            List result = !values.isEmpty() ? this.template.cql(cql.value(), values) : (args == null || args.length == 0 ? this.template.cql(cql.value()) : this.template.cql(cql.value(), args));
            return DynamicReturn.builder().withClassSource(this.typeClass).withMethodSource(method).withList(() -> result).withSingleResult((Supplier)DynamicReturn.toSingleResult((Method)method).apply(() -> result)).build().execute();
        }
        return method.invoke(this.repository, args);
    }
}

