/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.cassandra.column;

import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.cassandra.column.CassandraRepository;
import org.jnosql.artemis.cassandra.column.CassandraRepositoryProxy;
import org.jnosql.artemis.cassandra.column.CassandraTemplate;
import org.jnosql.artemis.column.ColumnRepositoryProducer;
import org.jnosql.artemis.column.ColumnTemplate;
import org.jnosql.artemis.spi.AbstractBean;

class CassandraRepositoryBean
extends AbstractBean<CassandraRepository> {
    private final Class type;
    private final Set<Type> types;
    private final Set<Annotation> qualifiers = Collections.singleton(new AnnotationLiteral<Default>(){});

    CassandraRepositoryBean(Class type, BeanManager beanManager) {
        super(beanManager);
        this.type = type;
        this.types = Collections.singleton(type);
    }

    public Class<?> getBeanClass() {
        return this.type;
    }

    public CassandraRepository create(CreationalContext<CassandraRepository> creationalContext) {
        CassandraTemplate template = (CassandraTemplate)this.getInstance(CassandraTemplate.class);
        ColumnRepositoryProducer producer = (ColumnRepositoryProducer)this.getInstance(ColumnRepositoryProducer.class);
        Repository repository = producer.get(this.type, (ColumnTemplate)template);
        CassandraRepositoryProxy handler = new CassandraRepositoryProxy(template, this.type, repository);
        return (CassandraRepository)Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, handler);
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return this.type.getName() + "@cassandra";
    }
}

