/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.cassandra.column;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jnosql.artemis.RepositoryAsync;
import org.jnosql.artemis.cassandra.column.CQL;
import org.jnosql.artemis.cassandra.column.CQLObjectUtil;
import org.jnosql.artemis.cassandra.column.CassandraTemplateAsync;

class CassandraRepositoryAsyncProxy<T>
implements InvocationHandler {
    private static final Predicate<Object> IS_NOT_CONSUMER = c -> !Consumer.class.isInstance(c);
    private static final Predicate<Object> IS_VALID_PARAMETER = IS_NOT_CONSUMER;
    private static final Consumer NOOP = t -> {};
    private final CassandraTemplateAsync templateAsync;
    private RepositoryAsync<?, ?> repositoryAsync;

    CassandraRepositoryAsyncProxy(CassandraTemplateAsync repository, RepositoryAsync<?, ?> repositoryAsync) {
        this.templateAsync = repository;
        this.repositoryAsync = repositoryAsync;
    }

    @Override
    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        CQL cql = method.getAnnotation(CQL.class);
        if (Objects.nonNull(cql)) {
            Map<String, Object> values;
            Consumer callBack = NOOP;
            if (Consumer.class.isInstance(args[args.length - 1])) {
                callBack = (Consumer)Consumer.class.cast(args[args.length - 1]);
            }
            if (!(values = CQLObjectUtil.getValues(args, method)).isEmpty()) {
                this.templateAsync.cql(cql.value(), values, callBack);
                return Void.class;
            }
            if (args == null || args.length == 1) {
                this.templateAsync.cql(cql.value(), callBack);
                return Void.class;
            }
            this.templateAsync.cql(cql.value(), callBack, Stream.of(args).filter(IS_VALID_PARAMETER).toArray(Object[]::new));
            return Void.class;
        }
        return method.invoke(this.repositoryAsync, args);
    }
}

